/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.util;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionUtil {
    public static Instruction getInstructionAt(List<Instruction> list, int offset) {
        Instruction i;
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.get((int)0).offset >= offset) {
            return list.get(0);
        }
        int length = list.size();
        if (length == 1) {
            return null;
        }
        if (list.get((int)(length - 1)).offset < offset) {
            return null;
        }
        int firstIndex = 0;
        int lastIndex = length - 1;
        while (true) {
            int medIndex = (lastIndex + firstIndex) / 2;
            i = list.get(medIndex);
            if (i.offset < offset) {
                firstIndex = medIndex + 1;
                continue;
            }
            if (list.get((int)(medIndex - 1)).offset < offset) break;
            lastIndex = medIndex - 1;
        }
        return i;
    }

    public static int getIndexForOffset(List<Instruction> list, int offset) {
        int medIndex;
        if (offset < 0) {
            throw new RuntimeException("offset=" + offset);
        }
        if (list == null || list.size() == 0) {
            return -1;
        }
        if (list.get((int)0).offset >= offset) {
            return 0;
        }
        int length = list.size();
        if (length == 1) {
            return -1;
        }
        if (list.get((int)(length - 1)).offset < offset) {
            return -1;
        }
        int firstIndex = 0;
        int lastIndex = length - 1;
        while (true) {
            medIndex = (lastIndex + firstIndex) / 2;
            Instruction i = list.get(medIndex);
            if (i.offset < offset) {
                firstIndex = medIndex + 1;
                continue;
            }
            if (list.get((int)(medIndex - 1)).offset < offset) break;
            lastIndex = medIndex - 1;
        }
        return medIndex;
    }

    public static boolean CheckNoJumpToInterval(List<Instruction> list, int firstIndex, int afterIndex, int firstOffset, int lastOffset) {
        int index = firstIndex;
        while (index < afterIndex) {
            Instruction i = list.get(index);
            switch (i.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: {
                    int jumpOffset = ((BranchInstruction)i).GetJumpOffset();
                    if (firstOffset >= jumpOffset || jumpOffset > lastOffset) break;
                    return false;
                }
            }
            ++index;
        }
        return true;
    }
}

