/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class CassiniSoldner
extends AbstractProj {
    private double ml0;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.008333333333333333;
    private static final double C3 = 0.041666666666666664;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.06666666666666667;

    @Override
    public String getName() {
        return I18n.tr("Cassini-Soldner", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "cass";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        double latitudeOfOrigin = Utils.toRadians(params.lat0);
        this.ml0 = this.mlfn(latitudeOfOrigin, Math.sin(latitudeOfOrigin), Math.cos(latitudeOfOrigin));
    }

    @Override
    public double[] project(double phi, double lam) {
        double sinphi = Math.sin(phi);
        double cosphi = Math.cos(phi);
        double n = 1.0 / Math.sqrt(1.0 - this.e2 * sinphi * sinphi);
        double tn = Math.tan(phi);
        double t = tn * tn;
        double a1 = lam * cosphi;
        double c = cosphi * cosphi * this.e2 / (1.0 - this.e2);
        double a2 = a1 * a1;
        double x = n * a1 * (1.0 - a2 * t * (0.16666666666666666 - (8.0 - t + 8.0 * c) * a2 * 0.008333333333333333));
        double y = this.mlfn(phi, sinphi, cosphi) - this.ml0 + n * tn * a2 * (0.5 + (5.0 - t + 6.0 * c) * a2 * 0.041666666666666664);
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        double ph1 = this.invMlfn(this.ml0 + y);
        double tn = Math.tan(ph1);
        double t = tn * tn;
        double n = Math.sin(ph1);
        double r = 1.0 / (1.0 - this.e2 * n * n);
        n = Math.sqrt(r);
        double dd = x / n;
        double d2 = dd * dd;
        double phi = ph1 - n * tn / (r *= (1.0 - this.e2) * n) * d2 * (0.5 - (1.0 + 3.0 * t) * d2 * 0.041666666666666664);
        double lam = dd * (1.0 + t * d2 * (-0.3333333333333333 + (1.0 + 3.0 * t) * d2 * 0.06666666666666667)) / Math.cos(ph1);
        return new double[]{phi, lam};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -1.0, 89.0, 1.0, false);
    }
}

