/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class SelfIntersectingWay
extends Test {
    protected static final int SELF_INTERSECT = 401;

    public SelfIntersectingWay() {
        super(I18n.tr("Self-intersecting ways", new Object[0]), I18n.tr("This test checks for ways that contain some of their nodes more than once.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        int last = w.getNodesCount();
        if (last < 2) {
            return;
        }
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(w.firstNode());
        int countFirst = 0;
        int countLast = 0;
        for (int i = 1; i < last; ++i) {
            Node n = w.getNode(i);
            if (nodes.contains(n)) {
                boolean ok = false;
                if (n == w.firstNode()) {
                    if (countFirst++ == 0) {
                        ok = true;
                    }
                } else if (i + 1 == last && countLast++ == 0) {
                    ok = true;
                }
                if (ok && countFirst + countLast <= 1) continue;
                this.errors.add(TestError.builder(this, Severity.WARNING, 401).message(I18n.tr("Self-intersecting ways", new Object[0])).primitives(w).highlight(n).build());
                break;
            }
            nodes.add(n);
        }
    }
}

