/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.AbstractReportProcessor;
import org.jfree.report.flow.DefaultReportJob;
import org.jfree.report.flow.ReportProcessor;
import org.jfree.report.flow.raw.XmlPrintReportProcessor;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.ReportParameters;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.JobDefinitionException;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ParameterMap;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.ReportJob;
import org.libreoffice.report.ReportJobDefinition;
import org.libreoffice.report.pentaho.StarReportDataFactory;
import org.libreoffice.report.pentaho.loader.InputRepositoryLoader;
import org.libreoffice.report.pentaho.model.OfficeDetailSection;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeReport;
import org.libreoffice.report.pentaho.output.chart.ChartRawReportProcessor;
import org.libreoffice.report.pentaho.output.spreadsheet.SpreadsheetRawReportProcessor;
import org.libreoffice.report.pentaho.output.text.TextRawReportProcessor;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PentahoReportJob
implements ReportJob {
    private static final Log LOGGER = LogFactory.getLog(PentahoReportJob.class);
    private final DataSourceFactory dataSourceFactory;
    private final OutputRepository outputRepository;
    private final JobProperties jobProperties;
    private OfficeDocument report;
    private final ResourceManager resourceManager;
    private final String outputName;
    private final ImageService imageService;
    private final InputRepository inputRepository;
    private final List masterValues;
    private final List detailColumns;

    public PentahoReportJob(ReportJobDefinition reportJobDefinition) throws JobDefinitionException {
        if (reportJobDefinition == null) {
            throw new NullPointerException();
        }
        this.jobProperties = reportJobDefinition.getProcessingParameters().copy();
        this.dataSourceFactory = (DataSourceFactory)this.jobProperties.getProperty("input.datasource-factory");
        if (this.dataSourceFactory == null) {
            throw new JobDefinitionException("DataSourceFactory must not be null.");
        }
        this.outputRepository = (OutputRepository)this.jobProperties.getProperty("output.repository");
        if (this.outputRepository == null) {
            throw new JobDefinitionException("OutputRepository must not be null.");
        }
        this.inputRepository = (InputRepository)this.jobProperties.getProperty("input.repository");
        if (this.inputRepository == null) {
            throw new JobDefinitionException("InputRepository must not be null.");
        }
        this.outputName = (String)this.jobProperties.getProperty("output.name");
        if (this.outputName == null) {
            throw new JobDefinitionException("OutputName must not be null");
        }
        this.imageService = (ImageService)this.jobProperties.getProperty("ImageService");
        if (this.imageService == null) {
            throw new JobDefinitionException("A valid image-service implementation must be given.");
        }
        this.masterValues = (ArrayList)this.jobProperties.getProperty("input.master-values");
        this.detailColumns = (ArrayList)this.jobProperties.getProperty("input.detail-columns");
        this.resourceManager = new ResourceManager();
        this.resourceManager.registerDefaults();
        this.resourceManager.registerLoader((ResourceLoader)new InputRepositoryLoader(this.inputRepository));
        try {
            this.report = this.parseReport(reportJobDefinition);
        }
        catch (ResourceException resourceException) {
            throw new JobDefinitionException("Failed to parse the report.", (Exception)((Object)resourceException));
        }
    }

    private OfficeDocument parseReport(ReportJobDefinition reportJobDefinition) throws ResourceException, JobDefinitionException {
        String string = (String)this.jobProperties.getProperty("input.name");
        if (string == null) {
            throw new JobDefinitionException("Report definition name must be given");
        }
        Resource resource = this.resourceManager.createDirectly((Object)("sun:oo://" + string), OfficeDocument.class);
        OfficeDocument officeDocument = (OfficeDocument)resource.getResource();
        officeDocument.setDataFactory(new StarReportDataFactory(this.dataSourceFactory));
        officeDocument.setJobProperties(reportJobDefinition.getProcessingParameters().copy());
        ReportParameters reportParameters = officeDocument.getInputParameters();
        ParameterMap parameterMap = reportJobDefinition.getQueryParameters();
        String[] stringArray = parameterMap.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            reportParameters.put(string2, parameterMap.get(string2));
        }
        return officeDocument;
    }

    private void collectGroupExpressions(Node[] nodeArray, List<Object[]> list, FormulaParser formulaParser, Expression[] expressionArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            Section section;
            Node node = nodeArray[i];
            if (node instanceof OfficeGroup) {
                section = (OfficeGroup)node;
                FormulaExpression formulaExpression = (FormulaExpression)((OfficeGroup)section).getGroupingExpression();
                if (formulaExpression == null) continue;
                try {
                    String string = formulaExpression.getFormulaExpression();
                    if (string == null) continue;
                    FormulaFunction formulaFunction = (FormulaFunction)formulaParser.parse(string);
                    LValue[] lValueArray = formulaFunction.getChildValues();
                    if (lValueArray.length > 0) {
                        Object[] objectArray;
                        String string2 = lValueArray[0].toString();
                        if (lValueArray[0] instanceof ContextLookup) {
                            objectArray = (Object[])lValueArray[0];
                            string2 = objectArray.getName();
                        }
                        for (int j = 0; j < expressionArray.length; ++j) {
                            ContextLookup contextLookup;
                            FormulaExpression formulaExpression2;
                            if (!(expressionArray[j] instanceof FormulaExpression) || !(formulaExpression2 = (FormulaExpression)expressionArray[j]).getName().equals(string2)) continue;
                            LValue lValue = formulaParser.parse(formulaExpression2.getFormulaExpression());
                            while (!(lValue instanceof ContextLookup)) {
                                if (lValue instanceof Term) {
                                    lValue = ((Term)lValue).getHeadValue();
                                    continue;
                                }
                                if (!(lValue instanceof FormulaFunction)) continue;
                                contextLookup = (FormulaFunction)lValue;
                                lValue = contextLookup.getChildValues()[0];
                            }
                            contextLookup = (ContextLookup)lValue;
                            string2 = contextLookup.getName();
                            break;
                        }
                        objectArray = new Object[]{string2, section.getAttribute("http://openoffice.org/2005/report", "sort-ascending")};
                        list.add(objectArray);
                    }
                }
                catch (ParseException parseException) {
                    LOGGER.error("ReportProcessing failed", parseException);
                }
            } else if (node instanceof OfficeDetailSection) {
                return;
            }
            if (!(node instanceof Section)) continue;
            section = (Section)node;
            this.collectGroupExpressions(section.getNodeArray(), list, formulaParser, expressionArray);
        }
    }

    private void collectSortExpressions(Node[] nodeArray, List<Object[]> list, FormulaParser formulaParser, Expression[] expressionArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            Section section;
            Node node = nodeArray[i];
            if (node instanceof OfficeGroup) {
                section = (OfficeGroup)node;
                String string = ((OfficeGroup)section).getSortingExpression();
                if (string == null) continue;
                Object[] objectArray = new Object[]{string, section.getAttribute("http://openoffice.org/2005/report", "sort-ascending")};
                list.add(objectArray);
            } else if (node instanceof OfficeDetailSection) {
                return;
            }
            if (!(node instanceof Section)) continue;
            section = (Section)node;
            this.collectSortExpressions(section.getNodeArray(), list, formulaParser, expressionArray);
        }
    }

    private void setMetaDataProperties(DefaultReportJob defaultReportJob) {
        defaultReportJob.getConfiguration().setConfigProperty("Author", (String)this.jobProperties.getProperty("Author"));
        defaultReportJob.getConfiguration().setConfigProperty("Title", (String)this.jobProperties.getProperty("Title"));
    }

    @Override
    public void execute() throws ReportExecutionException, IOException {
        DefaultReportJob defaultReportJob = new DefaultReportJob(this.report);
        this.setMetaDataProperties(defaultReportJob);
        String string = (String)this.jobProperties.getProperty("content-type");
        try {
            ReportParameters reportParameters = defaultReportJob.getParameters();
            if (this.masterValues != null && this.detailColumns != null) {
                reportParameters.put("master-values", this.masterValues);
                reportParameters.put("detail-columns", this.detailColumns);
            }
            Node[] nodeArray = this.report.getNodeArray();
            FormulaParser formulaParser = new FormulaParser();
            OfficeReport officeReport = (OfficeReport)((Section)nodeArray[0]).getNode(0);
            Section section = (Section)officeReport.getBodySection();
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            this.collectSortExpressions(section.getNodeArray(), arrayList, formulaParser, officeReport.getExpressions());
            reportParameters.put("sort-expressions", arrayList);
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
            this.collectGroupExpressions(section.getNodeArray(), arrayList2, formulaParser, officeReport.getExpressions());
            reportParameters.put("group-expressions", arrayList2);
            String string2 = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "command");
            String string3 = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "command-type");
            String string4 = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "escape-processing");
            this.report.setQuery(string2);
            reportParameters.put("command-type", string3);
            reportParameters.put("escape-processing", !"false".equals(string4));
            String string5 = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "filter");
            reportParameters.put("Filter", string5);
            reportParameters.put("MaxRows", this.report.getJobProperties().getProperty("MaxRows"));
            long l = System.currentTimeMillis();
            ReportProcessor reportProcessor = this.getProcessorForContentType(string);
            reportProcessor.processReport(defaultReportJob);
            defaultReportJob.close();
            long l2 = System.currentTimeMillis();
            LOGGER.debug("Report processing time: " + (l2 - l));
        }
        catch (Exception exception) {
            String string6 = exception.getMessage();
            if (string6 == null || string6.length() == 0) {
                string6 = "Failed to process the report";
            }
            throw new ReportExecutionException(string6, exception);
        }
    }

    private ReportProcessor getProcessorForContentType(String string) throws ReportExecutionException {
        AbstractReportProcessor abstractReportProcessor;
        if ("application/vnd.oasis.opendocument.spreadsheet".equals(string)) {
            abstractReportProcessor = new SpreadsheetRawReportProcessor(this.inputRepository, this.outputRepository, this.outputName, this.imageService, this.dataSourceFactory);
        } else if ("application/vnd.oasis.opendocument.text".equals(string)) {
            abstractReportProcessor = new TextRawReportProcessor(this.inputRepository, this.outputRepository, this.outputName, this.imageService, this.dataSourceFactory);
        } else if ("application/vnd.oasis.opendocument.chart".equals(string)) {
            abstractReportProcessor = new ChartRawReportProcessor(this.inputRepository, this.outputRepository, this.outputName, this.imageService, this.dataSourceFactory);
        } else if ("raw/text+xml".equals(string)) {
            abstractReportProcessor = new XmlPrintReportProcessor(System.out, "ISO-8859-1");
        } else {
            throw new ReportExecutionException("Invalid mime-type");
        }
        return abstractReportProcessor;
    }
}

