/*
 * Decompiled with CFR 0.152.
 */
package lucee;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import lucee.loader.TP;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.loader.engine.CFMLEngineFactorySupport;
import org.osgi.framework.Version;

public class VersionInfo {
    private static Version version = null;
    private static long created = -1L;

    public static Version getIntVersion() {
        VersionInfo.init();
        return version;
    }

    public static long getCreateTime() {
        VersionInfo.init();
        return created;
    }

    private static void init() {
        if (version != null) {
            return;
        }
        String content = "9000000:" + System.currentTimeMillis();
        try {
            content = VersionInfo.getContentAsString(new TP().getClass().getClassLoader().getResourceAsStream("lucee/version"), "UTF-8");
        }
        catch (IOException e) {
            // empty catch block
        }
        int index = content.indexOf(58);
        version = CFMLEngineFactorySupport.toVersion(content.substring(0, index), CFMLEngineFactory.VERSION_ZERO);
        String d = content.substring(index + 1);
        try {
            created = Long.parseLong(d);
        }
        catch (NumberFormatException nfe) {
            try {
                created = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z").parse(d).getTime();
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                created = 0L;
            }
        }
    }

    private static String getContentAsString(InputStream is, String charset) throws IOException {
        BufferedReader br = charset == null ? new BufferedReader(new InputStreamReader(is)) : new BufferedReader(new InputStreamReader(is, charset));
        StringBuffer content = new StringBuffer();
        String line = br.readLine();
        if (line != null) {
            content.append(line);
            while ((line = br.readLine()) != null) {
                content.append("\n" + line);
            }
        }
        br.close();
        return content.toString();
    }
}

