/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * dot(dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf), dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf)) => 8.7938999999999989lf
 * dot(dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf), dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf)) => -2.5038lf
 * dot(dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf), dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf)) => -2.5038lf
 * dot(dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf), dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf)) => 0.92260000000000009lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(dot(dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf), dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf)), 8.7938999999999989lf) <= 8.7938999999999999e-05lf ? 1 : -1] array0;
  double[distance(dot(dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf), dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf)), -2.5038lf) <= 2.5038000000000003e-05lf ? 1 : -1] array1;
  double[distance(dot(dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf), dvec4(-1.6499999999999999lf, 1.3300000000000001lf, 1.9299999999999999lf, 0.76000000000000001lf)), -2.5038lf) <= 2.5038000000000003e-05lf ? 1 : -1] array2;
  double[distance(dot(dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf), dvec4(0.80000000000000004lf, -0.14999999999999999lf, -0.51000000000000001lf, 0.0lf)), 0.92260000000000009lf) <= 9.2260000000000011e-06lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
