/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.0lf) => dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf)
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.33333333333333331lf) => dvec4(-2.3333333333333335lf, -0.33333333333333348lf, 0.33333333333333348lf, 2.3333333333333335lf)
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.66666666666666663lf) => dvec4(-2.666666666666667lf, 1.3333333333333333lf, -1.3333333333333333lf, 2.666666666666667lf)
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 1.0lf) => dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.0lf), dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf)) <= 4.0000000000000003e-05lf ? 1 : -1] array0;
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.33333333333333331lf), dvec4(-2.3333333333333335lf, -0.33333333333333348lf, 0.33333333333333348lf, 2.3333333333333335lf)) <= 3.3333333333333335e-05lf ? 1 : -1] array1;
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.66666666666666663lf), dvec4(-2.666666666666667lf, 1.3333333333333333lf, -1.3333333333333333lf, 2.666666666666667lf)) <= 4.2163702135578401e-05lf ? 1 : -1] array2;
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 1.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf)) <= 6.0000000000000008e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
