/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(-0.0lf, -0.0lf)
 * (0.0lf / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(-0.0lf, 0.0lf)
 * (-1.3333333333333333lf / dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(13.333333333333332lf, 1.1111111111111112lf)
 * (-1.3333333333333333lf / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(3.1746031746031744lf, -2.7777777777777777lf)
 * (0.84999999999999998lf / dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(-8.5lf, -0.70833333333333337lf)
 * (0.84999999999999998lf / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(-2.0238095238095237lf, 1.7708333333333333lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf / dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(-0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(-0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf / dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(13.333333333333332lf, 1.1111111111111112lf)) <= 0.0001337954953199144lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(3.1746031746031744lf, -2.7777777777777777lf)) <= 4.218311830450258e-05lf ? 1 : -1] array3;
  double[distance((0.84999999999999998lf / dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(-8.5lf, -0.70833333333333337lf)) <= 8.5294628266445447e-05lf ? 1 : -1] array4;
  double[distance((0.84999999999999998lf / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(-2.0238095238095237lf, 1.7708333333333333lf)) <= 2.6891737919120394e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
