/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat2(1.6000000000000001lf, 1.53lf, 0.76000000000000001lf, -1.0lf) * dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(-1.0720000000000001lf, 1.0469999999999999lf)
 * (dmat2(1.6000000000000001lf, 1.53lf, 0.76000000000000001lf, -1.0lf) * dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(-0.30720000000000003lf, -1.1226lf)
 * (dmat2(-0.13lf, -1.3999999999999999lf, -0.87lf, 1.3999999999999999lf) * dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(1.0569999999999999lf, -1.5399999999999998lf)
 * (dmat2(-0.13lf, -1.3999999999999999lf, -0.87lf, 1.3999999999999999lf) * dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(-0.36299999999999999lf, 1.2599999999999998lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dmat2(1.6000000000000001lf, 1.53lf, 0.76000000000000001lf, -1.0lf) * dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(-1.0720000000000001lf, 1.0469999999999999lf)) <= 1.4984635464368162e-05lf ? 1 : -1] array0;
  double[distance((dmat2(1.6000000000000001lf, 1.53lf, 0.76000000000000001lf, -1.0lf) * dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(-0.30720000000000003lf, -1.1226lf)) <= 1.1638739622484905e-05lf ? 1 : -1] array1;
  double[distance((dmat2(-0.13lf, -1.3999999999999999lf, -0.87lf, 1.3999999999999999lf) * dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(1.0569999999999999lf, -1.5399999999999998lf)) <= 1.8678460857361882e-05lf ? 1 : -1] array2;
  double[distance((dmat2(-0.13lf, -1.3999999999999999lf, -0.87lf, 1.3999999999999999lf) * dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(-0.36299999999999999lf, 1.2599999999999998lf)) <= 1.3112471162980682e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
