/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.10000000000000001lf, -1.2lf) * 0.0lf) => dvec2(-0.0lf, -0.0lf)
 * (dvec2(-0.10000000000000001lf, -1.2lf) * -1.3333333333333333lf) => dvec2(0.13333333333333333lf, 1.5999999999999999lf)
 * (dvec2(-0.10000000000000001lf, -1.2lf) * 0.84999999999999998lf) => dvec2(-0.085000000000000006lf, -1.02lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) * 0.0lf) => dvec2(-0.0lf, 0.0lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) * -1.3333333333333333lf) => dvec2(0.55999999999999994lf, -0.6399999999999999lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) * 0.84999999999999998lf) => dvec2(-0.35699999999999998lf, 0.40799999999999997lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) * 0.0lf), dvec2(-0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) * -1.3333333333333333lf), dvec2(0.13333333333333333lf, 1.5999999999999999lf)) <= 1.6055459438389729e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) * 0.84999999999999998lf), dvec2(-0.085000000000000006lf, -1.02lf)) <= 1.0235355391973452e-05lf ? 1 : -1] array2;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) * 0.0lf), dvec2(-0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array3;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) * -1.3333333333333333lf), dvec2(0.55999999999999994lf, -0.6399999999999999lf)) <= 8.5041166501877191e-06lf ? 1 : -1] array4;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) * 0.84999999999999998lf), dvec2(-0.35699999999999998lf, 0.40799999999999997lf)) <= 5.4213743644946715e-06lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
