/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(dvec2(-2.0lf, -1.4285714285714286lf)) => dvec2(-2.0lf, -1.0lf)
 * trunc(dvec2(-0.85714285714285721lf, -0.28571428571428581lf)) => dvec2(-0.0lf, -0.0lf)
 * trunc(dvec2(0.28571428571428559lf, 0.85714285714285676lf)) => dvec2(0.0lf, 0.0lf)
 * trunc(dvec2(1.4285714285714284lf, 2.0lf)) => dvec2(1.0lf, 2.0lf)
 * trunc(dvec2(0.0lf, 45027112.984140001lf)) => dvec2(0.0lf, 45027112.0lf)
 * trunc(dvec2(-45027112.984140001lf, 19584198736.473289lf)) => dvec2(-45027112.0lf, 19584198736.0lf)
 * trunc(dvec2(-19584198736.473289lf, 7.5165416231900006e+17lf)) => dvec2(-19584198736.0lf, 7.5165416231900006e+17lf)
 * trunc(dvec2(-7.5165416231900006e+17lf, 4.5027112340958568e+19lf)) => dvec2(-7.5165416231900006e+17lf, 4.5027112340958568e+19lf)
 * trunc(dvec2(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf)) => dvec2(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf)
 * trunc(dvec2(-8.6541968133854552e+39lf, 6.5496516851365496e+83lf)) => dvec2(-8.6541968133854552e+39lf, 6.5496516851365496e+83lf)
 * trunc(dvec2(-6.5496516851365496e+83lf, -2.0lf)) => dvec2(-6.5496516851365496e+83lf, -2.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(trunc(dvec2(-2.0lf, -1.4285714285714286lf)), dvec2(-2.0lf, -1.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array0;
  double[distance(trunc(dvec2(-0.85714285714285721lf, -0.28571428571428581lf)), dvec2(-0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance(trunc(dvec2(0.28571428571428559lf, 0.85714285714285676lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array2;
  double[distance(trunc(dvec2(1.4285714285714284lf, 2.0lf)), dvec2(1.0lf, 2.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array3;
  double[distance(trunc(dvec2(0.0lf, 45027112.984140001lf)), dvec2(0.0lf, 45027112.0lf)) <= 450.27112000000005lf ? 1 : -1] array4;
  double[distance(trunc(dvec2(-45027112.984140001lf, 19584198736.473289lf)), dvec2(-45027112.0lf, 19584198736.0lf)) <= 195842.5049809053lf ? 1 : -1] array5;
  double[distance(trunc(dvec2(-19584198736.473289lf, 7.5165416231900006e+17lf)), dvec2(-19584198736.0lf, 7.5165416231900006e+17lf)) <= 7516541623190.0029lf ? 1 : -1] array6;
  double[distance(trunc(dvec2(-7.5165416231900006e+17lf, 4.5027112340958568e+19lf)), dvec2(-7.5165416231900006e+17lf, 4.5027112340958568e+19lf)) <= 450333857237609.38lf ? 1 : -1] array7;
  double[distance(trunc(dvec2(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf)), dvec2(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf)) <= 8.6541968133854551e+34lf ? 1 : -1] array8;
  double[distance(trunc(dvec2(-8.6541968133854552e+39lf, 6.5496516851365496e+83lf)), dvec2(-8.6541968133854552e+39lf, 6.5496516851365496e+83lf)) <= 6.54965168513655e+78lf ? 1 : -1] array9;
  double[distance(trunc(dvec2(-6.5496516851365496e+83lf, -2.0lf)), dvec2(-6.5496516851365496e+83lf, -2.0lf)) <= 6.54965168513655e+78lf ? 1 : -1] array10;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length());
}
