/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * tan(-3.1415927) => -8.7422777e-08
 * tan(-1.0471976) => -1.7320509
 * tan(1.0471976) => 1.7320509
 * tan(3.1415927) => 8.7422777e-08
 */
#version 120

void main()
{
  float[distance(tan(-3.1415927), -8.7422777e-08) <= 9.9999997e-05 ? 1 : -1] array0;
  float[distance(tan(-1.0471976), -1.7320509) <= 0.0017320509 ? 1 : -1] array1;
  float[distance(tan(1.0471976), 1.7320509) <= 0.0017320509 ? 1 : -1] array2;
  float[distance(tan(3.1415927), 8.7422777e-08) <= 9.9999997e-05 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
