/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * tanh(-2.0) => -0.96402758
 * tanh(-0.66666669) => -0.58278298
 * tanh(0.66666669) => 0.58278298
 * tanh(2.0) => 0.96402758
 */
#version 150

void main()
{
  float[distance(tanh(-2.0), -0.96402758) <= 0.0009640276 ? 1 : -1] array0;
  float[distance(tanh(-0.66666669), -0.58278298) <= 0.00058278296 ? 1 : -1] array1;
  float[distance(tanh(0.66666669), 0.58278298) <= 0.00058278296 ? 1 : -1] array2;
  float[distance(tanh(2.0), 0.96402758) <= 0.0009640276 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
