/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(dvec2(-2.0lf, -1.4285714285714286lf)) => dvec2(-2.0lf, -1.0lf)
 * round(dvec2(-0.85714285714285721lf, -0.28571428571428581lf)) => dvec2(-1.0lf, -0.0lf)
 * round(dvec2(0.28571428571428559lf, 0.85714285714285676lf)) => dvec2(0.0lf, 1.0lf)
 * round(dvec2(1.4285714285714284lf, 2.0lf)) => dvec2(1.0lf, 2.0lf)
 */
#version 400

void main()
{
  double[distance(round(dvec2(-2.0lf, -1.4285714285714286lf)), dvec2(-2.0lf, -1.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array0;
  double[distance(round(dvec2(-0.85714285714285721lf, -0.28571428571428581lf)), dvec2(-1.0lf, -0.0lf)) <= 1.0000000000000001e-05lf ? 1 : -1] array1;
  double[distance(round(dvec2(0.28571428571428559lf, 0.85714285714285676lf)), dvec2(0.0lf, 1.0lf)) <= 1.0000000000000001e-05lf ? 1 : -1] array2;
  double[distance(round(dvec2(1.4285714285714284lf, 2.0lf)), dvec2(1.0lf, 2.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
