/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMetaItemSizeProvider;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

final class FixedMeta
extends MPPComponent {
    private int m_itemCount;
    private int m_adjustedItemCount;
    private Object[] m_array;
    private static final int MAGIC = -86004294;
    private static final int HEADER_SIZE = 16;

    FixedMeta(InputStream inputStream, final int n) throws IOException {
        this(inputStream, new FixedMetaItemSizeProvider(){

            public int getItemSize(int n3, int n2) {
                return n;
            }
        });
    }

    FixedMeta(InputStream inputStream, FixedMetaItemSizeProvider fixedMetaItemSizeProvider) throws IOException {
        int n = inputStream.available();
        if (this.readInt(inputStream) != -86004294) {
            throw new IOException("Bad magic number");
        }
        this.readInt(inputStream);
        this.m_itemCount = this.readInt(inputStream);
        this.readInt(inputStream);
        int n2 = fixedMetaItemSizeProvider.getItemSize(n, this.m_itemCount);
        this.m_adjustedItemCount = (n - 16) / n2;
        this.m_array = new Object[this.m_adjustedItemCount];
        for (int i = 0; i < this.m_adjustedItemCount; ++i) {
            this.m_array[i] = this.readByteArray(inputStream, n2);
        }
    }

    FixedMeta(InputStream inputStream, final FixedData fixedData, final int ... nArray) throws IOException {
        this(inputStream, new FixedMetaItemSizeProvider(){

            public int getItemSize(int n, int n2) {
                int n3 = nArray[0];
                int n4 = n - 16;
                int n5 = Integer.MIN_VALUE;
                int n6 = fixedData.getItemCount();
                for (int i = 0; i < nArray.length; ++i) {
                    int n7 = nArray[i];
                    if (n4 % n7 != 0) continue;
                    if (n4 / n7 == n6) {
                        n3 = n7;
                        break;
                    }
                    int n8 = n2 * n7 - n4;
                    if (n8 > 0 || n8 <= n5) continue;
                    n3 = n7;
                    n5 = n8;
                }
                return n3;
            }
        });
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public int getAdjustedItemCount() {
        return this.m_adjustedItemCount;
    }

    public byte[] getByteArrayValue(int n) {
        byte[] byArray = null;
        if (n >= 0 && n < this.m_array.length && this.m_array[n] != null) {
            byArray = (byte[])this.m_array[n];
        }
        return byArray;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN: FixedMeta");
        printWriter.println("   Adjusted Item count: " + this.m_adjustedItemCount);
        for (int i = 0; i < this.m_adjustedItemCount; ++i) {
            printWriter.println("   Data at index: " + i);
            printWriter.println("  " + MPPUtility.hexdump((byte[])this.m_array[i], true));
        }
        printWriter.println("END: FixedMeta");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

