/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;

class Locations {
    private static final String RELATIVE_RESOURCE_PATH = "JetBrains";
    private static final File ourDataDir;

    Locations() {
    }

    public static File getDataRoot() {
        return ourDataDir;
    }

    static {
        File dataDir = null;
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            if (appdata != null) {
                dataDir = new File(appdata, RELATIVE_RESOURCE_PATH);
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                if (SystemInfo.isMac) {
                    File dataRoot = new File(userHome, "/Library/Application Support");
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, RELATIVE_RESOURCE_PATH);
                    }
                } else if (SystemInfo.isUnix) {
                    File dataRoot;
                    String dataHome = System.getenv("XDG_DATA_HOME");
                    File file2 = dataRoot = dataHome == null ? new File(userHome, ".local/share") : new File(dataHome);
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, RELATIVE_RESOURCE_PATH);
                    }
                }
            }
        }
        if (dataDir == null) {
            dataDir = new File(PathManager.getSystemPath());
        }
        dataDir.mkdirs();
        ourDataDir = dataDir;
    }
}

