/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import org.jetbrains.annotations.NotNull;

public class DocumentUtil {
    @NotNull
    public static String getText(@NotNull RangeMarker range) {
        if (range == null) {
            DocumentUtil.$$$reportNull$$$0(0);
        }
        String string = range.getDocument().getText().substring(range.getStartOffset(), range.getEndOffset());
        if (string == null) {
            DocumentUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isEmpty(@NotNull RangeMarker rangeMarker) {
        if (rangeMarker == null) {
            DocumentUtil.$$$reportNull$$$0(2);
        }
        return rangeMarker.getStartOffset() == rangeMarker.getEndOffset();
    }

    public static int getStartLine(@NotNull RangeMarker range) {
        Document doc;
        if (range == null) {
            DocumentUtil.$$$reportNull$$$0(3);
        }
        if ((doc = range.getDocument()).getTextLength() == 0) {
            return 0;
        }
        return doc.getLineNumber(range.getStartOffset());
    }

    public static int getEndLine(@NotNull RangeMarker range) {
        if (range == null) {
            DocumentUtil.$$$reportNull$$$0(4);
        }
        Document document = range.getDocument();
        int endOffset = range.getEndOffset();
        int endLine = document.getLineNumber(endOffset);
        if (document.getTextLength() == endOffset && DocumentUtil.lastLineIsNotEmpty(document, endLine)) {
            return document.getLineCount();
        }
        return endLine;
    }

    private static boolean lastLineIsNotEmpty(@NotNull Document document, int line) {
        if (document == null) {
            DocumentUtil.$$$reportNull$$$0(5);
        }
        return document.getTextLength() != document.getLineStartOffset(line);
    }

    public static int getLength(@NotNull RangeMarker rangeMarker) {
        if (rangeMarker == null) {
            DocumentUtil.$$$reportNull$$$0(6);
        }
        return rangeMarker.getEndOffset() - rangeMarker.getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/util/DocumentUtil";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/util/DocumentUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lastLineIsNotEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

