/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.generator.SpellCheckerDictionaryGenerator;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.HashSet;

public class PythonSpellcheckerDictionaryGenerator
extends SpellCheckerDictionaryGenerator {
    public PythonSpellcheckerDictionaryGenerator(Project project, String dictOutputFolder) {
        super(project, dictOutputFolder, "python");
    }

    @Override
    protected void processFolder(HashSet<String> seenNames, PsiManager manager, VirtualFile folder) {
        if (!this.myExcludedFolders.contains(folder)) {
            String name = folder.getName();
            IdentifierSplitter.getInstance().split(name, TextRange.allOf((String)name), (Consumer<TextRange>)((Consumer)textRange -> {
                String word = textRange.substring(name);
                this.addSeenWord(seenNames, word, Language.ANY);
            }));
        }
        super.processFolder(seenNames, manager, folder);
    }

    @Override
    protected void processFile(PsiFile file2, final HashSet<String> seenNames) {
        file2.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyFunction(PyFunction node) {
                super.visitPyFunction(node);
                PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
            }

            @Override
            public void visitPyClass(PyClass node) {
                super.visitPyClass(node);
                PythonSpellcheckerDictionaryGenerator.this.processLeafsNames((PsiElement)node, seenNames);
            }

            @Override
            public void visitPyTargetExpression(PyTargetExpression node) {
                super.visitPyTargetExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class) instanceof PyFile) {
                    PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
                }
            }
        });
    }
}

