/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.tree.IElementType");
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final ArrayFactory<IElementType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new IElementType[count];
    public static final Predicate TRUE = type -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static final short MAX_INDEXED_TYPES = 15000;
    private static short size;
    private static volatile IElementType[] ourRegistry;
    private static final Object lock;
    private final short myIndex;
    private final String myDebugName;
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    static IElementType[] push(@NotNull IElementType[] types) {
        if (types == null) {
            IElementType.$$$reportNull$$$0(0);
        }
        Object object = lock;
        // MONITORENTER : object
        IElementType[] oldRegistry = ourRegistry;
        ourRegistry = types;
        size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
        // MONITOREXIT : object
        if (oldRegistry != null) return oldRegistry;
        IElementType.$$$reportNull$$$0(1);
        return oldRegistry;
    }

    public IElementType(@NotNull String debugName, @Nullable Language language) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(2);
        }
        this(debugName, language, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NotNull String debugName, @Nullable Language language, boolean register) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(3);
        }
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                LOG.assertTrue(this.myIndex < 15000, (Object)"Too many element types registered. Out of (short) range.");
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? (IElementType[])ArrayUtil.realloc((Object[])ourRegistry, (int)(ourRegistry.length * 3 / 2 + 1), ARRAY_FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            IElementType.$$$reportNull$$$0(4);
        }
        return language;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        return ourRegistry[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short getAllocatedTypesCount() {
        Object object = lock;
        synchronized (object) {
            return size;
        }
    }

    @NotNull
    public static IElementType[] enumerate(@NotNull Predicate p) {
        if (p == null) {
            IElementType.$$$reportNull$$$0(5);
        }
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value : ourRegistry) {
            if (value == null || !p.matches(value)) continue;
            matches.add(value);
        }
        IElementType[] iElementTypeArray = matches.toArray(new IElementType[matches.size()]);
        if (iElementTypeArray == null) {
            IElementType.$$$reportNull$$$0(6);
        }
        return iElementTypeArray;
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

