/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.DirectoryPruner;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.IUpdatingCommand;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.checkout.ExpandedModules;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class CheckoutCommand
extends AbstractCommand
implements IUpdatingCommand {
    @NonNls
    public static final String EXAM_DIR = "server: Updating ";
    private final List<String> modules = new ArrayList<String>();
    private boolean pruneDirectories;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private String updateByDate;
    private String updateByRevisionOrTag;
    private String alternativeCheckoutDirectory;
    private KeywordSubstitution keywordSubstitution;
    private boolean printToOutput;
    private final ThrowableRunnable<IOCommandException> myAfterCheckout;

    public CheckoutCommand(ThrowableRunnable<IOCommandException> afterCheckout) {
        this.myAfterCheckout = afterCheckout;
    }

    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ExpandedModules expandedModules = new ExpandedModules();
        if (!this.expandModules(expandedModules, listenerRegistry, requestProcessor, clientEnvironment)) {
            return false;
        }
        return this.checkout(expandedModules, requestProcessor, listenerRegistry, clientEnvironment);
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setUpdateByDate(null);
        this.setUpdateByRevisionOrTag(null);
        this.setKeywordSubstitution(null);
        this.setPruneDirectories(false);
        this.setPrintToOutput(false);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("checkout ");
        cvsCommandLine.append(this.getCvsArguments());
        for (String module : this.modules) {
            cvsCommandLine.append(module);
            cvsCommandLine.append(' ');
        }
        return cvsCommandLine.toString();
    }

    public void addModule(String module) {
        this.modules.add(module);
    }

    public void clearModules() {
        this.modules.clear();
    }

    private String getAlternativeCheckoutDirectory() {
        return this.alternativeCheckoutDirectory;
    }

    public void setAlternativeCheckoutDirectory(String alternativeCheckoutDirectory) {
        this.alternativeCheckoutDirectory = alternativeCheckoutDirectory;
    }

    private boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    public void setPruneDirectories(boolean pruneDirectories) {
        this.pruneDirectories = pruneDirectories;
    }

    private boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    @Override
    public void setResetStickyOnes(boolean resetStickyOnes) {
        this.resetStickyOnes = resetStickyOnes;
    }

    private boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    @Override
    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    private String getUpdateByDate() {
        return this.updateByDate;
    }

    @Override
    public void setUpdateByDate(String updateByDate) {
        this.updateByDate = updateByDate;
    }

    private String getUpdateByRevisionOrTag() {
        return this.updateByRevisionOrTag;
    }

    @Override
    public void setUpdateByRevisionOrTag(String updateByRevisionOrTag) {
        this.updateByRevisionOrTag = updateByRevisionOrTag;
    }

    private KeywordSubstitution getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(KeywordSubstitution keywordSubstitution) {
        this.keywordSubstitution = keywordSubstitution;
    }

    public void setPrintToOutput(boolean printToOutput) {
        this.printToOutput = printToOutput;
    }

    public boolean isPrintToOutput() {
        return this.printToOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expandModules(ExpandedModules expandedModules, ICvsListenerRegistry listenerRegistry, IRequestProcessor requestProcessor, IClientEnvironment clientEnvironment) throws CommandException, AuthenticationException {
        Requests requests = new Requests(new ExpandModulesRequest(), clientEnvironment);
        this.addModuleArguments(requests);
        requests.addLocalPathDirectoryRequest();
        expandedModules.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
            return bl;
        }
        finally {
            expandedModules.unregisterListeners(listenerRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkout(ExpandedModules expandedModules, IRequestProcessor requestProcessor, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        this.processExistingModules(expandedModules, clientEnvironment);
        try {
            cvsFiles = this.getFileObjects().size() > 0 ? this.scanFileSystem(clientEnvironment) : null;
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.CHECKOUT, clientEnvironment);
        if (this.getAlternativeCheckoutDirectory() != null) {
            requests.addArgumentRequest("-d");
            requests.addArgumentRequest(this.getAlternativeCheckoutDirectory());
        }
        requests.addArgumentRequest(!this.isRecursive(), "-l");
        requests.addArgumentRequest(this.isResetStickyOnes(), "-A");
        requests.addArgumentRequest(this.isUseHeadIfNotFound(), "-f");
        requests.addArgumentRequest(this.getUpdateByDate(), "-D");
        requests.addArgumentRequest(this.getUpdateByRevisionOrTag(), "-r");
        requests.addArgumentRequest(this.getKeywordSubstitution(), "-k");
        requests.addArgumentRequest(this.isPrintToOutput(), "-p");
        if (cvsFiles != null) {
            this.addFileRequests(cvsFiles, requests, clientEnvironment);
        }
        this.addModuleArguments(requests);
        requests.addLocalPathDirectoryRequest();
        DirectoryPruner directoryPruner = this.isPruneDirectories() ? new DirectoryPruner(clientEnvironment) : null;
        if (directoryPruner != null) {
            directoryPruner.registerListeners(listenerRegistry);
        }
        try {
            boolean bl = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
            return bl;
        }
        finally {
            try {
                if (this.myAfterCheckout != null) {
                    this.myAfterCheckout.run();
                }
            }
            finally {
                if (directoryPruner != null) {
                    directoryPruner.unregisterListeners(listenerRegistry);
                    try {
                        directoryPruner.pruneEmptyDirectories();
                    }
                    catch (IOException ex) {
                        throw new IOCommandException(ex);
                    }
                }
            }
        }
    }

    private void addModuleArguments(Requests requests) {
        for (String module : this.modules) {
            requests.addArgumentRequest(module);
        }
    }

    private void processExistingModules(ExpandedModules expandedModules, IClientEnvironment clientEnvironment) {
        ICvsFileSystem cvsFileSystem = clientEnvironment.getCvsFileSystem();
        for (String moduleName : expandedModules.getModules()) {
            DirectoryObject directoryObject;
            AbstractFileObject abstractFileObject;
            if (moduleName.equals(".")) {
                this.addFileObject(DirectoryObject.getRoot());
                break;
            }
            File moduleFile = cvsFileSystem.getLocalFileSystem().getFile(moduleName);
            if (moduleFile.isFile()) {
                abstractFileObject = cvsFileSystem.getLocalFileSystem().getFileObject(moduleFile);
                directoryObject = abstractFileObject.getParent();
            } else {
                directoryObject = cvsFileSystem.getLocalFileSystem().getDirectoryObject(moduleFile);
                abstractFileObject = directoryObject;
            }
            if (!clientEnvironment.getAdminReader().hasCvsDirectory(directoryObject, cvsFileSystem)) continue;
            this.addFileObject(abstractFileObject);
        }
    }

    private String getCvsArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.isResetStickyOnes()) {
            cvsArguments.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            cvsArguments.append("-f ");
        }
        if (this.isPrintToOutput()) {
            cvsArguments.append("-p ");
        }
        if (this.isPruneDirectories()) {
            cvsArguments.append("-P ");
        }
        if (this.getKeywordSubstitution() != null) {
            cvsArguments.append("-k");
            cvsArguments.append(this.getKeywordSubstitution());
            cvsArguments.append(' ');
        }
        if (this.getUpdateByRevisionOrTag() != null && this.getUpdateByRevisionOrTag().length() > 0) {
            cvsArguments.append("-r ");
            cvsArguments.append(this.getUpdateByRevisionOrTag());
            cvsArguments.append(' ');
        }
        if (this.getUpdateByDate() != null && this.getUpdateByDate().length() > 0) {
            cvsArguments.append("-D ");
            cvsArguments.append(this.getUpdateByDate());
            cvsArguments.append(' ');
        }
        return cvsArguments.toString();
    }

    @Override
    public void setUpdateByRevisionOrDate(String revision, String date) {
        this.setUpdateByRevisionOrTag(revision);
        this.setUpdateByDate(date);
    }
}

