/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedMap$1EntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Ordering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableSortedSet;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.Nullable;

public final class ImmutableSortedMap
extends ImmutableSortedMapFauxverideShim
implements NavigableMap {
    private static final Comparator NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet(Ordering.natural()), ImmutableList.of());
    private final transient RegularImmutableSortedSet keySet;
    private final transient ImmutableList valueList;
    private transient ImmutableSortedMap descendingMap;

    static ImmutableSortedMap emptyMap(Comparator comparator) {
        if (Ordering.natural().equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator), ImmutableList.of());
    }

    public static ImmutableSortedMap of() {
        return NATURAL_EMPTY_MAP;
    }

    ImmutableSortedMap(RegularImmutableSortedSet regularImmutableSortedSet, ImmutableList immutableList) {
        this(regularImmutableSortedSet, immutableList, null);
    }

    ImmutableSortedMap(RegularImmutableSortedSet regularImmutableSortedSet, ImmutableList immutableList, ImmutableSortedMap immutableSortedMap) {
        this.keySet = regularImmutableSortedSet;
        this.valueList = immutableList;
        this.descendingMap = immutableSortedMap;
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public Object get(@Nullable Object object) {
        int n = this.keySet.indexOf(object);
        return n == -1 ? null : this.valueList.get(n);
    }

    @Override
    boolean isPartialView() {
        return this.keySet.isPartialView() || this.valueList.isPartialView();
    }

    @Override
    public ImmutableSet entrySet() {
        return super.entrySet();
    }

    @Override
    ImmutableSet createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new ImmutableSortedMap$1EntrySet(this);
    }

    @Override
    public ImmutableSortedSet keySet() {
        return this.keySet;
    }

    @Override
    public ImmutableCollection values() {
        return this.valueList;
    }

    @Override
    public Comparator comparator() {
        return this.keySet().comparator();
    }

    @Override
    public Object firstKey() {
        return this.keySet().first();
    }

    @Override
    public Object lastKey() {
        return this.keySet().last();
    }

    private ImmutableSortedMap getSubMap(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        if (n == n2) {
            return ImmutableSortedMap.emptyMap(this.comparator());
        }
        return new ImmutableSortedMap(this.keySet.getSubSet(n, n2), this.valueList.subList(n, n2));
    }

    public ImmutableSortedMap headMap(Object object) {
        return this.headMap(object, false);
    }

    public ImmutableSortedMap headMap(Object object, boolean bl) {
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(object), bl));
    }

    public ImmutableSortedMap subMap(Object object, Object object2) {
        return this.subMap(object, true, object2, false);
    }

    public ImmutableSortedMap subMap(Object object, boolean bl, Object object2, boolean bl2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        Preconditions.checkArgument(this.comparator().compare(object, object2) <= 0, "expected fromKey <= toKey but %s > %s", object, object2);
        return this.headMap(object2, bl2).tailMap(object, bl);
    }

    public ImmutableSortedMap tailMap(Object object) {
        return this.tailMap(object, true);
    }

    public ImmutableSortedMap tailMap(Object object, boolean bl) {
        return this.getSubMap(this.keySet.tailIndex(Preconditions.checkNotNull(object), bl), this.size());
    }

    public Map.Entry lowerEntry(Object object) {
        return this.headMap(object, false).lastEntry();
    }

    public Object lowerKey(Object object) {
        return Maps.keyOrNull(this.lowerEntry(object));
    }

    public Map.Entry floorEntry(Object object) {
        return this.headMap(object, true).lastEntry();
    }

    public Object floorKey(Object object) {
        return Maps.keyOrNull(this.floorEntry(object));
    }

    public Map.Entry ceilingEntry(Object object) {
        return this.tailMap(object, true).firstEntry();
    }

    public Object ceilingKey(Object object) {
        return Maps.keyOrNull(this.ceilingEntry(object));
    }

    public Map.Entry higherEntry(Object object) {
        return this.tailMap(object, false).firstEntry();
    }

    public Object higherKey(Object object) {
        return Maps.keyOrNull(this.higherEntry(object));
    }

    @Override
    public Map.Entry firstEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.entrySet().asList().get(0);
    }

    @Override
    public Map.Entry lastEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.entrySet().asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    public final Map.Entry pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    public ImmutableSortedMap descendingMap() {
        ImmutableSortedMap immutableSortedMap = this.descendingMap;
        if (immutableSortedMap == null) {
            if (this.isEmpty()) {
                immutableSortedMap = ImmutableSortedMap.emptyMap(Ordering.from(this.comparator()).reverse());
                return immutableSortedMap;
            }
            immutableSortedMap = new ImmutableSortedMap((RegularImmutableSortedSet)this.keySet.descendingSet(), this.valueList.reverse(), this);
            return immutableSortedMap;
        }
        return immutableSortedMap;
    }

    public ImmutableSortedSet navigableKeySet() {
        return this.keySet;
    }

    public ImmutableSortedSet descendingKeySet() {
        return this.keySet.descendingSet();
    }

    static /* synthetic */ RegularImmutableSortedSet access$200(ImmutableSortedMap immutableSortedMap) {
        return immutableSortedMap.keySet;
    }

    static /* synthetic */ ImmutableList access$300(ImmutableSortedMap immutableSortedMap) {
        return immutableSortedMap.valueList;
    }
}

