/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Util;

public abstract class DateRangeRules {
    private static final Predicate<Filter> FILTER_PREDICATE = new PredicateImpl<Filter>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(Filter filter) {
            ExtractFinder finder = (ExtractFinder)ExtractFinder.THREAD_INSTANCES.get();
            assert (finder.timeUnits.isEmpty()) : "previous user did not clean up";
            try {
                filter.getCondition().accept(finder);
                boolean bl = !finder.timeUnits.isEmpty();
                return bl;
            }
            finally {
                finder.timeUnits.clear();
            }
        }
    };
    public static final RelOptRule FILTER_INSTANCE = new FilterDateRangeRule(RelFactories.LOGICAL_BUILDER);
    private static final Map<TimeUnitRange, Integer> TIME_UNIT_CODES = ImmutableMap.builder().put((Object)TimeUnitRange.YEAR, (Object)1).put((Object)TimeUnitRange.MONTH, (Object)2).put((Object)TimeUnitRange.DAY, (Object)5).put((Object)TimeUnitRange.HOUR, (Object)10).put((Object)TimeUnitRange.MINUTE, (Object)12).put((Object)TimeUnitRange.SECOND, (Object)13).put((Object)TimeUnitRange.MILLISECOND, (Object)14).build();
    private static final Map<TimeUnitRange, TimeUnitRange> TIME_UNIT_PARENTS = ImmutableMap.builder().put((Object)TimeUnitRange.MONTH, (Object)TimeUnitRange.YEAR).put((Object)TimeUnitRange.DAY, (Object)TimeUnitRange.MONTH).put((Object)TimeUnitRange.HOUR, (Object)TimeUnitRange.DAY).put((Object)TimeUnitRange.MINUTE, (Object)TimeUnitRange.HOUR).put((Object)TimeUnitRange.SECOND, (Object)TimeUnitRange.MINUTE).put((Object)TimeUnitRange.MILLISECOND, (Object)TimeUnitRange.SECOND).put((Object)TimeUnitRange.MICROSECOND, (Object)TimeUnitRange.SECOND).build();

    private DateRangeRules() {
    }

    public static Set<TimeUnitRange> extractTimeUnits(RexNode e) {
        ExtractFinder finder = (ExtractFinder)ExtractFinder.THREAD_INSTANCES.get();
        try {
            assert (finder.timeUnits.isEmpty()) : "previous user did not clean up";
            e.accept(finder);
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)finder.timeUnits);
            return immutableSet;
        }
        finally {
            finder.timeUnits.clear();
        }
    }

    public static class ExtractShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final TimeUnitRange timeUnit;
        private final Map<String, RangeSet<Calendar>> operandRanges;
        private final Deque<RexCall> calls = new ArrayDeque<RexCall>();

        public ExtractShuttle(RexBuilder rexBuilder, TimeUnitRange timeUnit, Map<String, RangeSet<Calendar>> operandRanges) {
            this.rexBuilder = rexBuilder;
            this.timeUnit = timeUnit;
            Bug.upgrade("Change type to Map<RexNode, RangeSet<Calendar>> when [CALCITE-1367] is fixed");
            this.operandRanges = operandRanges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RexNode visitCall(RexCall call) {
            switch (call.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN: {
                    RexNode op0 = (RexNode)call.operands.get(0);
                    RexNode op1 = (RexNode)call.operands.get(1);
                    switch (op0.getKind()) {
                        case LITERAL: {
                            if (!this.isExtractCall(op1)) break;
                            return this.foo(call.getKind().reverse(), ((RexCall)op1).getOperands().get(1), (RexLiteral)op0);
                        }
                    }
                    switch (op1.getKind()) {
                        case LITERAL: {
                            if (!this.isExtractCall(op0)) break;
                            return this.foo(call.getKind(), ((RexCall)op0).getOperands().get(1), (RexLiteral)op1);
                        }
                    }
                    break;
                }
            }
            this.calls.push(call);
            try {
                RexNode rexNode = super.visitCall(call);
                return rexNode;
            }
            finally {
                this.calls.pop();
            }
        }

        @Override
        protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
            if (exprs.isEmpty()) {
                return ImmutableList.of();
            }
            switch (this.calls.peek().getKind()) {
                case AND: {
                    return super.visitList(exprs, update);
                }
            }
            ImmutableMap save = ImmutableMap.copyOf(this.operandRanges);
            ImmutableList.Builder clonedOperands = ImmutableList.builder();
            for (RexNode rexNode : exprs) {
                RexNode clonedOperand = rexNode.accept(this);
                if (clonedOperand != rexNode && update != null) {
                    update[0] = true;
                }
                clonedOperands.add((Object)clonedOperand);
                this.operandRanges.clear();
                this.operandRanges.putAll((Map<String, RangeSet<Calendar>>)save);
            }
            return clonedOperands.build();
        }

        boolean isExtractCall(RexNode e) {
            switch (e.getKind()) {
                case EXTRACT: {
                    RexCall call = (RexCall)e;
                    RexLiteral flag = (RexLiteral)call.operands.get(0);
                    TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
                    return timeUnit == this.timeUnit;
                }
            }
            return false;
        }

        RexNode foo(SqlKind comparison, RexNode operand, RexLiteral literal) {
            ImmutableRangeSet rangeSet = this.operandRanges.get(operand.toString());
            if (rangeSet == null) {
                rangeSet = ImmutableRangeSet.of().complement();
            }
            TreeRangeSet s2 = TreeRangeSet.create();
            int v = ((BigDecimal)literal.getValue()).intValue() - (this.timeUnit == TimeUnitRange.MONTH ? 1 : 0);
            for (Range r : rangeSet.asRanges()) {
                switch (this.timeUnit) {
                    case YEAR: {
                        Calendar c = Util.calendar();
                        c.clear();
                        c.set(v, 0, 1);
                        s2.add(this.baz(this.timeUnit, comparison, c));
                        break;
                    }
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: {
                        if (!r.hasLowerBound()) break;
                        Calendar c = (Calendar)((Calendar)r.lowerEndpoint()).clone();
                        int i = 0;
                        while (this.next(c, this.timeUnit, v, (Range<Calendar>)r, i++ > 0)) {
                            s2.add(this.baz(this.timeUnit, comparison, c));
                        }
                        break;
                    }
                }
            }
            s2.removeAll(rangeSet.complement());
            this.operandRanges.put(operand.toString(), (RangeSet<Calendar>)ImmutableRangeSet.copyOf((RangeSet)s2));
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            for (Range r : s2.asRanges()) {
                nodes.add(this.toRex(operand, (Range<Calendar>)r));
            }
            return RexUtil.composeDisjunction(this.rexBuilder, nodes);
        }

        private boolean next(Calendar c, TimeUnitRange timeUnit, int v, Range<Calendar> r, boolean strict) {
            Calendar original = (Calendar)c.clone();
            int code = (Integer)TIME_UNIT_CODES.get(timeUnit);
            while (true) {
                c.set(code, v);
                int v2 = c.get(code);
                if (v2 < v) continue;
                if (!strict || original.compareTo(c) != 0) break;
                c.add((Integer)TIME_UNIT_CODES.get(TIME_UNIT_PARENTS.get(timeUnit)), 1);
            }
            return r.contains((Comparable)c);
        }

        private RexNode toRex(RexNode operand, Range<Calendar> r) {
            SqlBinaryOperator op;
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            if (r.hasLowerBound()) {
                op = r.lowerBoundType() == BoundType.CLOSED ? SqlStdOperatorTable.GREATER_THAN_OR_EQUAL : SqlStdOperatorTable.GREATER_THAN;
                nodes.add(this.rexBuilder.makeCall((SqlOperator)op, operand, this.rexBuilder.makeDateLiteral(DateString.fromCalendarFields((Calendar)r.lowerEndpoint()))));
            }
            if (r.hasUpperBound()) {
                op = r.upperBoundType() == BoundType.CLOSED ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN;
                nodes.add(this.rexBuilder.makeCall((SqlOperator)op, operand, this.rexBuilder.makeDateLiteral(DateString.fromCalendarFields((Calendar)r.upperEndpoint()))));
            }
            return RexUtil.composeConjunction(this.rexBuilder, nodes, false);
        }

        private Range<Calendar> baz(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            switch (comparison) {
                case EQUALS: {
                    return Range.closedOpen((Comparable)this.round(c, timeUnit, true), (Comparable)this.round(c, timeUnit, false));
                }
                case LESS_THAN: {
                    return Range.lessThan((Comparable)this.round(c, timeUnit, true));
                }
                case LESS_THAN_OR_EQUAL: {
                    return Range.lessThan((Comparable)this.round(c, timeUnit, false));
                }
                case GREATER_THAN: {
                    return Range.atLeast((Comparable)this.round(c, timeUnit, false));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Range.atLeast((Comparable)this.round(c, timeUnit, true));
                }
            }
            throw new AssertionError((Object)comparison);
        }

        private Calendar round(Calendar c, TimeUnitRange timeUnit, boolean down) {
            c = (Calendar)c.clone();
            if (!down) {
                Integer code = (Integer)TIME_UNIT_CODES.get(timeUnit);
                int v = c.get(code);
                c.set(code, v + 1);
            }
            return c;
        }
    }

    private static class ExtractFinder
    extends RexVisitorImpl {
        private final Set<TimeUnitRange> timeUnits = EnumSet.noneOf(TimeUnitRange.class);
        private static final ThreadLocal<ExtractFinder> THREAD_INSTANCES = new ThreadLocal<ExtractFinder>(){

            @Override
            protected ExtractFinder initialValue() {
                return new ExtractFinder();
            }
        };

        private ExtractFinder() {
            super(true);
        }

        @Override
        public Object visitCall(RexCall call) {
            switch (call.getKind()) {
                case EXTRACT: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(0);
                    this.timeUnits.add((TimeUnitRange)operand.getValue());
                }
            }
            return super.visitCall(call);
        }
    }

    public static class FilterDateRangeRule
    extends RelOptRule {
        public FilterDateRangeRule(RelBuilderFactory relBuilderFactory) {
            super(FilterDateRangeRule.operand(Filter.class, null, FILTER_PREDICATE, FilterDateRangeRule.any()), relBuilderFactory, "FilterDateRangeRule");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            RexNode condition = filter.getCondition();
            HashMap<String, RangeSet<Calendar>> operandRanges = new HashMap<String, RangeSet<Calendar>>();
            Set<TimeUnitRange> timeUnitRangeSet = DateRangeRules.extractTimeUnits(condition);
            if (!timeUnitRangeSet.contains(TimeUnitRange.YEAR)) {
                return;
            }
            for (TimeUnitRange timeUnit : timeUnitRangeSet) {
                condition = condition.accept(new ExtractShuttle(rexBuilder, timeUnit, operandRanges));
            }
            if (RexUtil.eq(condition, filter.getCondition())) {
                return;
            }
            RelBuilder relBuilder = this.relBuilderFactory.create(filter.getCluster(), null);
            relBuilder.push(filter.getInput()).filter(condition);
            call.transformTo(relBuilder.build());
        }
    }
}

