/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.SolrJettyTestBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.util.RestTestHarness;
import org.apache.solr.util.TestHarness;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.AfterClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class RestTestBase
extends SolrJettyTestBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static RestTestHarness restTestHarness;

    @AfterClass
    public static void cleanUpHarness() throws IOException {
        if (restTestHarness != null) {
            restTestHarness.close();
        }
        restTestHarness = null;
    }

    public static void createJettyAndHarness(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        RestTestBase.createJetty(solrHome, configFile, schemaFile, context, stopAtShutdown, extraServlets);
        restTestHarness = new RestTestHarness(() -> jetty.getBaseUrl().toString() + "/" + "collection1");
    }

    public static void assertU(String update) {
        RestTestBase.assertU(null, update);
    }

    public static void assertU(String message, String update) {
        RestTestBase.checkUpdateU(message, update, true);
    }

    public static void assertFailedU(String update) {
        RestTestBase.assertFailedU(null, update);
    }

    public static void assertFailedU(String message, String update) {
        RestTestBase.checkUpdateU(message, update, false);
    }

    private static void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            String m;
            String string = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String response = restTestHarness.validateUpdate(update);
                if (response != null) {
                    RestTestBase.fail((String)(m + "update was not successful: " + response));
                }
            } else {
                String response = restTestHarness.validateErrorUpdate(update);
                if (response != null) {
                    RestTestBase.fail((String)(m + "update succeeded, but should have failed: " + response));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static void assertQ(String request, String ... tests) {
        try {
            String response;
            String results;
            String path;
            String query;
            int queryStartPos = request.indexOf(63);
            if (-1 == queryStartPos) {
                query = "";
                path = request;
            } else {
                query = request.substring(queryStartPos + 1);
                path = request.substring(0, queryStartPos);
            }
            if (!query.matches(".*wt=schema\\.xml.*")) {
                query = RestTestBase.setParam(query, "wt", "xml");
            }
            if (null != (results = TestHarness.validateXPath(response = restTestHarness.query(request = path + '?' + RestTestBase.setParam(query, "indent", "on")), tests))) {
                String msg = "REQUEST FAILED: xpath=" + results + "\n\txml response was: " + response + "\n\trequest was:" + request;
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            SolrException.log((Logger)log, (String)("REQUEST FAILED: " + request), (Throwable)e2);
            throw new RuntimeException("Exception during query", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String JQ(String request) throws Exception {
        String response;
        String path;
        String query;
        int queryStartPos = request.indexOf(63);
        if (-1 == queryStartPos) {
            query = "";
            path = request;
        } else {
            query = request.substring(queryStartPos + 1);
            path = request.substring(0, queryStartPos);
        }
        query = RestTestBase.setParam(query, "wt", "json");
        request = path + '?' + RestTestBase.setParam(query, "indent", "on");
        boolean failed = true;
        try {
            response = restTestHarness.query(request);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: " + request);
            }
        }
        return response;
    }

    public static void assertJQ(String request, String ... tests) throws Exception {
        RestTestBase.assertJQ(request, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJQ(String request, double delta, String ... tests) throws Exception {
        String response;
        String path;
        String query;
        int queryStartPos = request.indexOf(63);
        if (-1 == queryStartPos) {
            query = "";
            path = request;
        } else {
            query = request.substring(queryStartPos + 1);
            path = request.substring(0, queryStartPos);
        }
        query = RestTestBase.setParam(query, "wt", "json");
        request = path + '?' + RestTestBase.setParam(query, "indent", "on");
        boolean failed = true;
        try {
            response = restTestHarness.query(request);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: " + request);
            }
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            String testJSON = RestTestBase.json(test);
            try {
                failed = true;
                String err = JSONTestUtil.match(response, testJSON, delta);
                failed = false;
                if (err == null) continue;
                log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                throw new RuntimeException(err);
            }
            finally {
                if (failed) {
                    log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                }
            }
        }
    }

    public static void assertJPut(String request, String content, String ... tests) throws Exception {
        RestTestBase.assertJPut(request, content, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJPut(String request, String content, double delta, String ... tests) throws Exception {
        String response;
        String path;
        String query;
        int queryStartPos = request.indexOf(63);
        if (-1 == queryStartPos) {
            query = "";
            path = request;
        } else {
            query = request.substring(queryStartPos + 1);
            path = request.substring(0, queryStartPos);
        }
        query = RestTestBase.setParam(query, "wt", "json");
        request = path + '?' + RestTestBase.setParam(query, "indent", "on");
        boolean failed = true;
        try {
            response = restTestHarness.put(request, content);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: " + request);
            }
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            String testJSON = RestTestBase.json(test);
            try {
                failed = true;
                String err = JSONTestUtil.match(response, testJSON, delta);
                failed = false;
                if (err == null) continue;
                log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                throw new RuntimeException(err);
            }
            finally {
                if (failed) {
                    log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                }
            }
        }
    }

    public static void assertJPost(String request, String content, String ... tests) throws Exception {
        RestTestBase.assertJPost(request, content, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJPost(String request, String content, double delta, String ... tests) throws Exception {
        String response;
        String path;
        String query;
        int queryStartPos = request.indexOf(63);
        if (-1 == queryStartPos) {
            query = "";
            path = request;
        } else {
            query = request.substring(queryStartPos + 1);
            path = request.substring(0, queryStartPos);
        }
        query = RestTestBase.setParam(query, "wt", "json");
        request = path + '?' + RestTestBase.setParam(query, "indent", "on");
        boolean failed = true;
        try {
            response = restTestHarness.post(request, content);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: " + request);
            }
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            String testJSON = RestTestBase.json(test);
            try {
                failed = true;
                String err = JSONTestUtil.match(response, testJSON, delta);
                failed = false;
                if (err == null) continue;
                log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                throw new RuntimeException(err);
            }
            finally {
                if (failed) {
                    log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                }
            }
        }
    }

    public static void assertJDelete(String request, String ... tests) throws Exception {
        RestTestBase.assertJDelete(request, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJDelete(String request, double delta, String ... tests) throws Exception {
        String response;
        String path;
        String query;
        int queryStartPos = request.indexOf(63);
        if (-1 == queryStartPos) {
            query = "";
            path = request;
        } else {
            query = request.substring(queryStartPos + 1);
            path = request.substring(0, queryStartPos);
        }
        query = RestTestBase.setParam(query, "wt", "json");
        request = path + '?' + RestTestBase.setParam(query, "indent", "on");
        boolean failed = true;
        try {
            response = restTestHarness.delete(request);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: " + request);
            }
        }
        for (String test : tests) {
            if (null == test || 0 == test.length()) continue;
            String testJSON = RestTestBase.json(test);
            try {
                failed = true;
                String err = JSONTestUtil.match(response, testJSON, delta);
                failed = false;
                if (err == null) continue;
                log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                throw new RuntimeException(err);
            }
            finally {
                if (failed) {
                    log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + request + "\n");
                }
            }
        }
    }

    private static String setParam(String query, String paramToSet, String valueToSet) {
        if (null == valueToSet) {
            valueToSet = "";
        }
        try {
            StringBuilder builder = new StringBuilder();
            if (null == query || query.trim().isEmpty()) {
                builder.append(paramToSet);
                builder.append('=');
                StrUtils.partialURLEncodeVal((Appendable)builder, (String)valueToSet);
                return builder.toString();
            }
            MultiMapSolrParams requestParams = SolrRequestParsers.parseQueryString((String)query);
            String[] values = requestParams.getParams(paramToSet);
            if (null == values) {
                builder.append(query);
                builder.append('&');
                builder.append(paramToSet);
                builder.append('=');
                StrUtils.partialURLEncodeVal((Appendable)builder, (String)valueToSet);
                return builder.toString();
            }
            if (1 == values.length && valueToSet.equals(values[0])) {
                return query;
            }
            boolean isFirst = true;
            for (Map.Entry entry : requestParams.getMap().entrySet()) {
                String key = (String)entry.getKey();
                String[] valarr = (String[])entry.getValue();
                if (key.equals(paramToSet)) continue;
                for (String val : valarr) {
                    builder.append(isFirst ? "" : Character.valueOf('&'));
                    isFirst = false;
                    builder.append(key);
                    builder.append('=');
                    StrUtils.partialURLEncodeVal((Appendable)builder, (String)(null == val ? "" : val));
                }
            }
            builder.append(isFirst ? "" : Character.valueOf('&'));
            builder.append(paramToSet);
            builder.append('=');
            StrUtils.partialURLEncodeVal((Appendable)builder, (String)valueToSet);
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

