/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ActiveReplicaWatcher;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveReplicaCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public MoveReplicaCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.moveReplica(this.ocmh.zkStateReader.getClusterState(), message, results);
    }

    private void moveReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        boolean isSharedFS;
        log.debug("moveReplica() : {}", (Object)Utils.toJSONString((Object)message));
        this.ocmh.checkRequired(message, "collection", "targetNode");
        String collection = message.getStr("collection");
        String targetNode = message.getStr("targetNode");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        boolean inPlaceMove = message.getBool("inPlaceMove", true);
        int timeout = message.getInt("timeout", Integer.valueOf(600));
        String async = message.getStr("async");
        DocCollection coll = clusterState.getCollection(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " does not exist");
        }
        if (!clusterState.getLiveNodes().contains(targetNode)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target node: " + targetNode + " not in live nodes: " + clusterState.getLiveNodes());
        }
        Replica replica = null;
        if (message.containsKey("replica")) {
            String replicaName = message.getStr("replica");
            replica = coll.getReplica(replicaName);
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " replica: " + replicaName + " does not exist");
            }
        } else {
            String sourceNode = message.getStr("sourceNode", message.getStr("fromNode"));
            if (sourceNode == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'sourceNode or 'fromNode' is a required param");
            }
            String shardId = message.getStr("shard");
            if (shardId == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'shard' is a required param");
            }
            Slice slice = clusterState.getCollection(collection).getSlice(shardId);
            ArrayList sliceReplicas = new ArrayList(slice.getReplicas());
            Collections.shuffle(sliceReplicas, OverseerCollectionMessageHandler.RANDOM);
            for (Replica r : slice.getReplicas()) {
                if (!r.getNodeName().equals(sourceNode)) continue;
                replica = r;
            }
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " node: " + sourceNode + " does not have any replica belonging to shard: " + (String)shardId);
            }
        }
        log.info("Replica will be moved to node {}: {}", (Object)targetNode, (Object)replica);
        Slice slice = null;
        for (Slice s : coll.getSlices()) {
            if (!s.getReplicas().contains(replica)) continue;
            slice = s;
        }
        assert (slice != null);
        Object dataDir = replica.get("dataDir");
        boolean bl = isSharedFS = replica.getBool("shared_storage", false) && dataDir != null;
        if (isSharedFS && inPlaceMove) {
            log.debug("-- moveHdfsReplica");
            this.moveHdfsReplica(clusterState, results, dataDir.toString(), targetNode, async, coll, replica, slice, timeout, waitForFinalState);
        } else {
            log.debug("-- moveNormalReplica (inPlaceMove=" + inPlaceMove + ", isSharedFS=" + isSharedFS);
            this.moveNormalReplica(clusterState, results, targetNode, async, coll, replica, slice, timeout, waitForFinalState);
        }
    }

    private void moveHdfsReplica(ClusterState clusterState, NamedList results, String dataDir, String targetNode, String async, DocCollection coll, Replica replica, Slice slice, int timeout, boolean waitForFinalState) throws Exception {
        String skipCreateReplicaInClusterState = "true";
        if (clusterState.getLiveNodes().contains(replica.getNodeName())) {
            skipCreateReplicaInClusterState = "false";
            ZkNodeProps removeReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "replica", replica.getName()});
            removeReplicasProps.getProperties().put("deleteDataDir", false);
            removeReplicasProps.getProperties().put("deleteIndex", false);
            if (async != null) {
                removeReplicasProps.getProperties().put("async", async);
            }
            NamedList deleteResult = new NamedList();
            this.ocmh.deleteReplica(clusterState, removeReplicasProps, deleteResult, null);
            if (deleteResult.get("failure") != null) {
                String errorString = String.format(Locale.ROOT, "Failed to cleanup replica collection=%s shard=%s name=%s, failure=%s", coll.getName(), slice.getName(), replica.getName(), deleteResult.get("failure"));
                log.warn(errorString);
                results.add("failure", (Object)errorString);
                return;
            }
            TimeOut timeOut = new TimeOut(20L, TimeUnit.SECONDS);
            while (!timeOut.hasTimedOut() && (coll = this.ocmh.zkStateReader.getClusterState().getCollection(coll.getName())).getReplica(replica.getName()) != null) {
                Thread.sleep(100L);
            }
            if (timeOut.hasTimedOut()) {
                results.add("failure", (Object)"Still see deleted replica in clusterstate!");
                return;
            }
        }
        String ulogDir = replica.getStr("ulogDir");
        ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "node", targetNode, "coreNodeName", replica.getName(), "name", replica.getCoreName(), "waitForFinalState", String.valueOf(waitForFinalState), "skipCreateReplicaInClusterState", skipCreateReplicaInClusterState, "ulogDir", ulogDir.substring(0, ulogDir.lastIndexOf(UpdateLog.TLOG_NAME)), "dataDir", dataDir});
        if (async != null) {
            addReplicasProps.getProperties().put("async", async);
        }
        NamedList addResult = new NamedList();
        try {
            this.ocmh.addReplica(this.ocmh.zkStateReader.getClusterState(), addReplicasProps, addResult, null);
        }
        catch (Exception e) {
            String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s, failure=%s", coll.getName(), slice.getName(), targetNode, addResult.get("failure"));
            results.add("failure", (Object)errorString);
            log.warn("Error adding replica " + addReplicasProps + " - trying to roll back...", (Throwable)e);
            addReplicasProps = addReplicasProps.plus("node", (Object)replica.getNodeName());
            NamedList rollback = new NamedList();
            this.ocmh.addReplica(this.ocmh.zkStateReader.getClusterState(), addReplicasProps, rollback, null);
            if (rollback.get("failure") != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal error during MOVEREPLICA of " + replica + ", collection may be inconsistent: " + rollback.get("failure"));
            }
            return;
        }
        if (addResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s, failure=%s", coll.getName(), slice.getName(), targetNode, addResult.get("failure"));
            log.warn(errorString);
            results.add("failure", (Object)errorString);
            log.debug("--- trying to roll back...");
            addReplicasProps = addReplicasProps.plus("node", (Object)replica.getNodeName());
            NamedList rollback = new NamedList();
            try {
                this.ocmh.addReplica(this.ocmh.zkStateReader.getClusterState(), addReplicasProps, rollback, null);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal error during MOVEREPLICA of " + replica + ", collection may be inconsistent!", (Throwable)e);
            }
            if (rollback.get("failure") != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal error during MOVEREPLICA of " + replica + ", collection may be inconsistent! Failure: " + rollback.get("failure"));
            }
            return;
        }
        String successString = String.format(Locale.ROOT, "MOVEREPLICA action completed successfully, moved replica=%s at node=%s to replica=%s at node=%s", replica.getCoreName(), replica.getNodeName(), replica.getCoreName(), targetNode);
        results.add("success", (Object)successString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveNormalReplica(ClusterState clusterState, NamedList results, String targetNode, String async, DocCollection coll, Replica replica, Slice slice, int timeout, boolean waitForFinalState) throws Exception {
        String newCoreName = Assign.buildCoreName(this.ocmh.overseer.getSolrCloudManager().getDistribStateManager(), coll, slice.getName(), replica.getType());
        ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "node", targetNode, "name", newCoreName});
        if (async != null) {
            addReplicasProps.getProperties().put("async", async);
        }
        NamedList addResult = new NamedList();
        SolrCloseableLatch countDownLatch = new SolrCloseableLatch(1, (SolrCloseable)this.ocmh);
        ActiveReplicaWatcher watcher = null;
        ZkNodeProps props = this.ocmh.addReplica(clusterState, addReplicasProps, addResult, null);
        log.debug("props " + props);
        if (replica.equals((Object)slice.getLeader()) || waitForFinalState) {
            watcher = new ActiveReplicaWatcher(coll.getName(), null, Collections.singletonList(newCoreName), countDownLatch);
            log.debug("-- registered watcher " + watcher);
            this.ocmh.zkStateReader.registerCollectionStateWatcher(coll.getName(), (CollectionStateWatcher)watcher);
        }
        if (addResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s, failure=", coll.getName(), slice.getName(), targetNode, addResult.get("failure"));
            log.warn(errorString);
            results.add("failure", (Object)errorString);
            if (watcher != null) {
                this.ocmh.zkStateReader.removeCollectionStateWatcher(coll.getName(), (CollectionStateWatcher)watcher);
            }
            return;
        }
        if (watcher != null) {
            try {
                log.debug("Waiting for leader's replica to recover.");
                if (!countDownLatch.await((long)timeout, TimeUnit.SECONDS)) {
                    String errorString = String.format(Locale.ROOT, "Timed out waiting for leader's replica to recover, collection=%s shard=%s on node=%s", coll.getName(), slice.getName(), targetNode);
                    log.warn(errorString);
                    results.add("failure", (Object)errorString);
                    return;
                }
                log.debug("Replica " + watcher.getActiveReplicas() + " is active - deleting the source...");
            }
            finally {
                this.ocmh.zkStateReader.removeCollectionStateWatcher(coll.getName(), (CollectionStateWatcher)watcher);
            }
        }
        ZkNodeProps removeReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "replica", replica.getName()});
        if (async != null) {
            removeReplicasProps.getProperties().put("async", async);
        }
        NamedList deleteResult = new NamedList();
        this.ocmh.deleteReplica(clusterState, removeReplicasProps, deleteResult, null);
        if (deleteResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to cleanup replica collection=%s shard=%s name=%s, failure=%s", coll.getName(), slice.getName(), replica.getName(), deleteResult.get("failure"));
            log.warn(errorString);
            results.add("failure", (Object)errorString);
        } else {
            String successString = String.format(Locale.ROOT, "MOVEREPLICA action completed successfully, moved replica=%s at node=%s to replica=%s at node=%s", replica.getCoreName(), replica.getNodeName(), newCoreName, targetNode);
            results.add("success", (Object)successString);
        }
    }
}

