/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.Arrays;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.metadata.LanguagePrecondition;
import org.apache.uima.resource.metadata.impl.SimplePrecondition_impl;

public class LanguagePrecondition_impl
extends SimplePrecondition_impl
implements LanguagePrecondition {
    private static final long serialVersionUID = -5526826405334750929L;

    public LanguagePrecondition_impl() {
        FSTypeConstraint typeCon = ConstraintFactory.instance().createTypeConstraint();
        typeCon.add("uima.tcas.DocumentAnnotation");
        super.setFsMatchConstraint(typeCon);
        super.setFeatureName("language");
        super.setPredicate("LanguageSubsumed");
    }

    public String[] getLanguages() {
        return (String[])this.getComparisonValue();
    }

    public void setLanguages(String[] aLanguages) {
        this.setComparisonValue(aLanguages);
    }

    public void setComparisonValue(Object aValue) {
        if (!(aValue instanceof String[])) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{aValue, "aValue", "setComparisonValue"});
        }
        String[] languages = (String[])aValue;
        String[] normalizedLanguages = new String[languages.length];
        int i = 0;
        for (String language : languages) {
            normalizedLanguages[i++] = Language.normalize(language);
            if (!"x-unspecified".equals(normalizedLanguages[i - 1])) continue;
            super.setComparisonValue(new String[]{"x-unspecified"});
            return;
        }
        super.setComparisonValue(normalizedLanguages);
    }

    public void setFeatureName(String aFeatureName) {
        throw new UIMA_UnsupportedOperationException("unsupported_method", new Object[]{this.getClass().getName(), "setFeatureName"});
    }

    public void setFsIndexName(String aIndexName) {
        throw new UIMA_UnsupportedOperationException("unsupported_method", new Object[]{this.getClass().getName(), "setFsIndexName"});
    }

    public void setFsMatchConstraint(FSMatchConstraint aConstraint) {
        throw new UIMA_UnsupportedOperationException("unsupported_method", new Object[]{this.getClass().getName(), "setFsMatchConstraint"});
    }

    public void setPredicate(String aPredicate) {
        throw new UIMA_UnsupportedOperationException("unsupported_method", new Object[]{this.getClass().getName(), "setPredicate"});
    }

    public boolean equals(Object aObject) {
        Object cv2;
        if (!(aObject instanceof LanguagePrecondition)) {
            return false;
        }
        LanguagePrecondition p = (LanguagePrecondition)aObject;
        Object cv1 = this.getComparisonValue();
        if (cv1.equals(cv2 = p.getComparisonValue())) {
            return true;
        }
        if (cv1 instanceof Object[]) {
            if (!(cv2 instanceof Object[])) {
                return false;
            }
            if (!Arrays.equals((Object[])cv1, (Object[])cv2)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h = this.getFeatureName().hashCode();
        if (this.getComparisonValue() != null) {
            h += this.getComparisonValue().hashCode();
        }
        return h;
    }
}

