/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.fonts.CIDFont;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;

public class PDFToUnicodeCMap
extends PDFCMap {
    protected CIDFont cidFont;

    public PDFToUnicodeCMap(CIDFont cidMetrics, String name, PDFCIDSystemInfo sysInfo) {
        super(name, sysInfo);
        this.cidFont = cidMetrics;
    }

    public void fillInPDF(StringBuffer p) {
        this.writeCIDInit(p);
        this.writeCIDSystemInfo(p);
        this.writeVersionTypeName(p);
        this.writeCodeSpaceRange(p);
        this.writeBFEntries(p);
        this.writeWrapUp(p);
        this.add(p.toString());
    }

    protected void writeCIDSystemInfo(StringBuffer p) {
        p.append("/CIDSystemInfo\n");
        p.append("<< /Registry (Adobe)\n");
        p.append("/Ordering (UCS)\n");
        p.append("/Supplement 0\n");
        p.append(">> def\n");
    }

    protected void writeVersionTypeName(StringBuffer p) {
        p.append("/CMapName /Adobe-Identity-UCS def\n");
        p.append("/CMapType 2 def\n");
    }

    protected void writeBFEntries(StringBuffer p) {
        if (this.cidFont == null) {
            return;
        }
        char[] charArray = this.cidFont.getCharsUsed();
        if (charArray != null) {
            this.writeBFCharEntries(p, charArray);
            this.writeBFRangeEntries(p, charArray);
        }
    }

    protected void writeBFCharEntries(StringBuffer p, char[] charArray) {
        int entriesThisSection;
        int totalEntries = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (this.partOfRange(charArray, i)) continue;
            ++totalEntries;
        }
        if (totalEntries < 1) {
            return;
        }
        int remainingEntries = totalEntries;
        int charIndex = 0;
        do {
            entriesThisSection = Math.min(remainingEntries, 100);
            p.append(entriesThisSection + " beginbfchar\n");
            for (int i = 0; i < entriesThisSection; ++i) {
                while (this.partOfRange(charArray, charIndex)) {
                    ++charIndex;
                }
                p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charIndex), 4) + "> ");
                p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                ++charIndex;
            }
            p.append("endbfchar\n");
        } while ((remainingEntries -= entriesThisSection) > 0);
    }

    protected void writeBFRangeEntries(StringBuffer p, char[] charArray) {
        int entriesThisSection;
        int totalEntries = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (!this.startOfRange(charArray, i)) continue;
            ++totalEntries;
        }
        if (totalEntries < 1) {
            return;
        }
        int remainingEntries = totalEntries;
        int charIndex = 0;
        do {
            entriesThisSection = Math.min(remainingEntries, 100);
            p.append(entriesThisSection + " beginbfrange\n");
            for (int i = 0; i < entriesThisSection; ++i) {
                while (!this.startOfRange(charArray, charIndex)) {
                    ++charIndex;
                }
                p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charIndex), 4) + "> ");
                p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(this.endOfRange(charArray, charIndex)), 4) + "> ");
                p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                ++charIndex;
            }
            p.append("endbfrange\n");
        } while ((remainingEntries -= entriesThisSection) > 0);
    }

    private int endOfRange(char[] charArray, int startOfRange) {
        int i;
        for (i = startOfRange; i < charArray.length - 1 && this.sameRangeEntryAsNext(charArray, i); ++i) {
        }
        return i;
    }

    private boolean partOfRange(char[] charArray, int arrayIndex) {
        if (charArray.length < 2) {
            return false;
        }
        if (arrayIndex == 0) {
            return this.sameRangeEntryAsNext(charArray, 0);
        }
        if (arrayIndex == charArray.length - 1) {
            return this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
        }
        if (this.sameRangeEntryAsNext(charArray, arrayIndex - 1)) {
            return true;
        }
        return this.sameRangeEntryAsNext(charArray, arrayIndex);
    }

    private boolean sameRangeEntryAsNext(char[] charArray, int firstItem) {
        if (charArray[firstItem] + '\u0001' != charArray[firstItem + 1]) {
            return false;
        }
        return firstItem / 256 == (firstItem + 1) / 256;
    }

    private boolean startOfRange(char[] charArray, int arrayIndex) {
        if (!this.partOfRange(charArray, arrayIndex)) {
            return false;
        }
        if (arrayIndex == 0) {
            return true;
        }
        if (arrayIndex == charArray.length - 1) {
            return false;
        }
        return !this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
    }

    public static String padHexString(String input, int numChars) {
        int length = input.length();
        if (length >= numChars) {
            return input;
        }
        StringBuffer returnString = new StringBuffer();
        for (int i = 1; i <= numChars - length; ++i) {
            returnString.append("0");
        }
        returnString.append(input);
        return returnString.toString();
    }
}

