/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email;

import com.sun.mail.imap.IMAPSSLStore;
import com.sun.mail.pop3.POP3SSLStore;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class Pop3 {
    public static String c_dir = "/tmp/";
    public static String a_sep = System.getProperty("file.separator");
    public static String a_line = System.getProperty("line.separator");
    private String c_host = "";
    private String c_username = "";
    private String c_password = "";
    private Session session = null;
    private Store store = null;
    private Folder folder = null;
    private Folder[] folders = null;
    private Folder[] defaut_folders = null;
    private Message[] message = null;
    private int c_port = 110;
    private String c_protocol = "pop3";
    public static final String POP = "pop3";
    public static final int POP_PORT = 110;
    public static final int POPS_PORT = 995;
    public static final String IMAP = "imap";
    public static final int IMAP_PORT = 143;
    public static final int IMAPS_PORT = 993;
    private boolean SSL = false;
    private boolean TLS = false;
    private int c_timeout = 0;
    private char c_separator = (char)46;
    private boolean c_debug = false;

    public Pop3() {
    }

    public Pop3(String _dir, String _host, String _username, String _password) {
        this(_dir, _host, _username, _password, 110, POP);
    }

    public Pop3(String _dir, String _host, String _username, String _password, int _port, String _protocol) {
        c_dir = _dir;
        this.c_host = _host;
        this.c_username = _username;
        this.c_password = _password;
        this.c_port = _port;
        this.c_protocol = _protocol;
        if (!c_dir.endsWith(a_sep)) {
            c_dir = c_dir + a_sep;
        }
    }

    public void setDir(String _dir) {
        c_dir = _dir;
        if (!c_dir.endsWith(a_sep)) {
            c_dir = c_dir + a_sep;
        }
    }

    public void setHost(String _host) {
        this.c_host = _host;
    }

    public void setLogin(String _username) {
        this.c_username = _username;
    }

    public void setPwd(String _password) {
        this.c_password = _password;
    }

    public void setPort(int _port) {
        this.c_port = _port;
    }

    public void setTLS(boolean _tls) {
        this.TLS = _tls;
    }

    public Message[] getMail() throws NoSuchProviderException, MessagingException {
        return this.getMail("INBOX", this.c_debug);
    }

    public Message[] getMail(boolean sDebug) throws NoSuchProviderException, MessagingException {
        return this.getMail("INBOX", sDebug);
    }

    public Message[] getMail(String box) throws NoSuchProviderException, MessagingException {
        return this.getMail(box, false);
    }

    public Message[] getMail(String box, boolean sDebug) throws NoSuchProviderException, MessagingException {
        if (box == null) {
            throw new MessagingException("Folder is null, defaut is INBOX!");
        }
        Properties props = this.getSessionProperties();
        this.session = Session.getDefaultInstance((Properties)props, null);
        this.session.setDebug(sDebug);
        if (this.SSL) {
            URLName url = new URLName(this.c_protocol, this.c_host, this.c_port, null, this.c_username, this.c_password);
            if (this.c_protocol.equals(POP)) {
                this.store = new POP3SSLStore(this.session, url);
            } else if (this.c_protocol.equals(IMAP)) {
                this.store = new IMAPSSLStore(this.session, url);
            }
            this.store.connect();
        } else {
            this.store = this.session.getStore(this.c_protocol);
            this.store.connect(this.c_host, this.c_username, this.c_password);
        }
        if (this.store.isConnected()) {
            Folder defaultFolder = this.store.getDefaultFolder();
            if (defaultFolder == null) {
                throw new MessagingException("Can't find defaut FOLDER !!!");
            }
            this.defaut_folders = defaultFolder.list();
            this.c_separator = defaultFolder.getSeparator();
            this.folder = this.store.getFolder(box);
            if (this.folder.exists()) {
                this.folder.open(2);
                if (this.folder.isOpen()) {
                    try {
                        this.folders = this.folder.list();
                    }
                    catch (MessagingException me) {
                        // empty catch block
                    }
                    this.message = this.folder.getMessages();
                }
            }
        }
        return this.message;
    }

    private Properties getSessionProperties() throws MessagingException {
        Properties props = System.getProperties();
        if (this.c_protocol.equals(POP)) {
            props.put("mail.pop3.port", "" + this.c_port);
            if (this.TLS) {
                props.put("mail.pop3.starttls.enable", "true");
            }
            if (this.c_timeout != 0) {
                props.put("mail.pop3.connectiontimeout", "" + this.c_timeout);
                props.put("mail.pop3.timeout", "" + this.c_timeout);
            }
        } else if (this.c_protocol.equals(IMAP)) {
            props.put("mail.imap.port", "" + this.c_port);
            if (this.TLS) {
                props.put("mail.imap.starttls.enable", "true");
            }
            if (this.c_timeout != 0) {
                props.put("mail.imap.connectiontimeout", "" + this.c_timeout);
                props.put("mail.imap.timeout", "" + this.c_timeout);
            }
        } else {
            throw new MessagingException("Unknow Protocol : " + this.c_protocol);
        }
        if (this.c_debug) {
            props.put("mail.debug", "true");
        }
        if (this.SSL) {
            try {
                Security.addProvider((java.security.Provider)new Provider());
            }
            catch (SecurityException se) {
                throw new MessagingException("" + se);
            }
            if (this.c_protocol.equals(POP)) {
                props.put("mail.pop3.socketFactory.port", "" + this.c_port);
                props.put("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.pop3.socketFactory.fallback", "true");
            } else if (this.c_protocol.equals(IMAP)) {
                props.put("mail.imap.socketFactory.port", "" + this.c_port);
                props.put("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.imap.socketFactory.fallback", "true");
            }
        }
        return props;
    }

    public void setDebug(boolean _debug) {
        this.c_debug = _debug;
    }

    public void setSocketTimeout(int timeout) {
        this.c_timeout = timeout;
    }

    public void close(boolean _del) throws MessagingException {
        if (this.folder.isOpen()) {
            this.folder.close(_del);
        }
        this.store.close();
    }

    public void setSecurePOP3(boolean _ssl) {
        this.SSL = _ssl;
    }

    public boolean isNew(int num) throws MessagingException {
        return this.message[num].isSet(Flags.Flag.RECENT);
    }

    public boolean isRead(int num) throws MessagingException {
        return this.message[num].isSet(Flags.Flag.SEEN);
    }

    public int countMessage() throws MessagingException {
        return this.folder.getMessageCount();
    }

    public int countMessageUnread() throws MessagingException {
        return this.folder.getUnreadMessageCount();
    }

    public int countNewMessage() throws MessagingException {
        return this.folder.getNewMessageCount();
    }

    public int countMessageRead() throws MessagingException {
        return this.countMessage() - this.countMessageUnread();
    }

    public int countOldMessage() throws MessagingException {
        return this.countMessage() - this.countNewMessage();
    }

    public void deleteMessage(int num) throws MessagingException {
        this.message[num].setFlag(Flags.Flag.DELETED, true);
    }

    public boolean createFolder(String _folder) throws MessagingException {
        if (_folder == null) {
            return false;
        }
        Folder newFolder = this.store.getFolder(_folder);
        return newFolder.create(1);
    }

    public boolean deleteFolder(String _folder) throws MessagingException {
        if (_folder == null) {
            return false;
        }
        Folder del_folder = this.store.getFolder(_folder);
        if (del_folder.exists()) {
            if (del_folder.isOpen()) {
                del_folder.close(true);
            }
            return del_folder.delete(false);
        }
        return false;
    }

    public boolean copyFolderMessages(String _srcFolder, String _destFolder) throws MessagingException {
        if (_srcFolder == null || _destFolder == null) {
            return false;
        }
        Folder sourceF = this.store.getFolder(_srcFolder);
        Folder targetF = this.store.getFolder(_destFolder);
        if (sourceF.exists() && targetF.exists()) {
            sourceF.open(1);
            targetF.open(2);
            if (sourceF.isOpen() && targetF.isOpen()) {
                Message[] msgs = sourceF.getMessages();
                sourceF.copyMessages(msgs, targetF);
                return true;
            }
        }
        return false;
    }

    public boolean renameFolder(String _srcFolder, String _destFolder) throws MessagingException {
        if (_srcFolder == null || _destFolder == null) {
            return false;
        }
        Folder targetF = null;
        Folder sourceF = this.store.getFolder(_srcFolder);
        sourceF.open(1);
        if (sourceF.exists() && sourceF.isOpen() && this.createFolder(_destFolder)) {
            targetF = this.store.getFolder(_destFolder);
            targetF.open(2);
            if (targetF.exists() && targetF.isOpen()) {
                Message[] msgs = sourceF.getMessages();
                sourceF.copyMessages(msgs, targetF);
                if (sourceF.isOpen()) {
                    sourceF.close(true);
                }
                return sourceF.delete(true);
            }
        }
        return false;
    }

    public boolean setSubscribed(String _folder, boolean _subscribed) throws MessagingException {
        if (_folder == null) {
            return false;
        }
        Folder subcr_folder = this.store.getFolder(_folder);
        if (!subcr_folder.exists()) {
            return false;
        }
        subcr_folder.setSubscribed(_subscribed);
        return true;
    }

    public Folder[] getSubscribedFolder() {
        if (this.folders == null) {
            return null;
        }
        ArrayList<Folder> array = new ArrayList<Folder>();
        int n = this.folders.length;
        for (int i = 0; i < n; ++i) {
            if (!this.folders[i].isSubscribed()) continue;
            array.add(this.folders[i]);
        }
        Folder[] subcr_folder = new Folder[array.size()];
        array.toArray(subcr_folder);
        return subcr_folder;
    }

    public Folder[] getUnSubscribedFolder() {
        if (this.folders == null) {
            return null;
        }
        ArrayList<Folder> array = new ArrayList<Folder>();
        int n = this.folders.length;
        for (int i = 0; i < n; ++i) {
            if (this.folders[i].isSubscribed()) continue;
            array.add(this.folders[i]);
        }
        Folder[] subcr_folder = new Folder[array.size()];
        array.toArray(subcr_folder);
        return subcr_folder;
    }

    public char getSep() {
        return this.c_separator;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Folder[] getFolders() {
        return this.folders;
    }

    public Folder[] getRootFolders() {
        return this.defaut_folders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Pop3 pop = new Pop3("c:\\temp", "xxxx.org", "xxxx", "xxxx", 993, IMAP);
        pop.setSecurePOP3(true);
        pop.setDebug(true);
        pop.setSocketTimeout(5000);
        try {
            System.err.println("Start Job --- Pop3");
            Message[] pop_message = pop.getMail(true);
            int n = pop_message.length;
            for (int i = 0; i < n; ++i) {
                System.err.println("\tFrom : " + pop_message[i].getFrom()[0]);
                System.err.println("\tSubject : " + pop_message[i].getSubject());
                System.err.println("\tDate : " + pop_message[i].getSentDate());
                Address[] add = pop_message[i].getReplyTo();
                System.err.println("\tReplyTo : " + add[0].toString());
                System.out.println();
                System.out.println();
            }
            System.out.println("End Job --- Pop3");
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Pile : ");
            e.printStackTrace();
        }
        finally {
            try {
                pop.close(true);
            }
            catch (MessagingException messagingException) {}
        }
    }

    public static final class FileBinary {
        private String c_file = "";
        private byte[] c_b = null;
        private int c_size = -1;
        private String c_header = "";

        public FileBinary(String _file) {
            this.c_file = _file;
            this.attach(_file);
        }

        public String getFile() {
            return this.c_file;
        }

        public String getFileName() {
            File f_file = new File(this.c_file);
            return f_file.getName();
        }

        private void attach(String c_file) {
            RandomAccessFile c_raf = null;
            try {
                c_raf = new RandomAccessFile(c_file, "rw");
                this.c_size = (int)c_raf.length();
                this.c_b = new byte[this.c_size < 80 ? this.c_size : 80];
                c_raf.readFully(this.c_b);
                this.c_header = new String(this.c_b, 0, this.c_b.length, "8859_1");
                c_raf.close();
            }
            catch (Throwable t) {
                try {
                    c_raf.close();
                }
                catch (Exception h) {
                    // empty catch block
                }
            }
        }

        public boolean isExe() {
            if (this.c_size < 2) {
                return false;
            }
            return this.c_header.substring(0, 2).equals("MZ");
        }

        public boolean isPdf() {
            if (this.c_size < 4) {
                return false;
            }
            return this.c_header.substring(0, 4).equals("%PDF");
        }

        public boolean isAvi() {
            if (this.c_size < 4) {
                return false;
            }
            return this.c_header.substring(0, 4).equals("RIFF");
        }

        public boolean isGif() {
            if (this.c_size < 3) {
                return false;
            }
            return this.c_header.substring(0, 3).equals("GIF");
        }

        public boolean isBmp() {
            if (this.c_size < 3) {
                return false;
            }
            return this.c_header.substring(0, 3).equals("BMP");
        }

        public boolean isJpg() {
            if (this.c_b.length < 10) {
                return false;
            }
            return this.c_header.substring(6, 10).equalsIgnoreCase("JFIF");
        }

        public boolean isZip() {
            if (this.c_b.length < 2) {
                return false;
            }
            return this.c_header.substring(0, 2).equalsIgnoreCase("PK");
        }

        public boolean isMSOffice() {
            if (this.c_b.length < 8) {
                return false;
            }
            byte[] bytes = this.c_header.substring(0, 8).getBytes();
            String sbytes = this.tohexString(bytes, bytes.length, 0);
            return sbytes.equalsIgnoreCase("D0CF11E0A1B11AE1");
        }

        public boolean isWord() {
            return this.c_file.lastIndexOf("doc") != -1;
        }

        public boolean isExcel() {
            return this.c_file.lastIndexOf("xls") != -1;
        }

        public boolean isPPoint() {
            return this.c_file.lastIndexOf("ppt") != -1;
        }

        public boolean isHtml() {
            return this.c_file.lastIndexOf("htm") != -1 || this.c_file.lastIndexOf("html") != -1;
        }

        public boolean isTxt() {
            return this.c_file.lastIndexOf("txt") != -1;
        }

        public boolean isSuffixe(String _ext) {
            if (_ext == null) {
                return false;
            }
            return this.c_file.lastIndexOf(_ext) != -1;
        }

        private String tohexString(byte[] abyte0, int i, int j) {
            StringBuffer stringbuffer = new StringBuffer(i * 2);
            for (int l = 0; l < i; ++l) {
                int k = abyte0[l + j] < 0 ? abyte0[l + j] + 256 : abyte0[l + j];
                stringbuffer.insert(2 * l, this.halfBytetoHex(k / 16));
                stringbuffer.insert(2 * l + 1, this.halfBytetoHex(k - 16 * (k / 16)));
            }
            return stringbuffer.toString();
        }

        private char halfBytetoHex(int i) {
            if (i <= 9) {
                return (char)(48 + i);
            }
            if (i <= 15) {
                return (char)(65 + i - 10);
            }
            return '-';
        }
    }

    public static final class Tools {
        public static String saveFile(String _filename, InputStream _input) throws IOException {
            int aByte;
            if (_filename == null) {
                _filename = File.createTempFile("xx", ".out").getName();
            }
            File file = new File(c_dir + _filename);
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            BufferedInputStream bis = new BufferedInputStream(_input);
            while ((aByte = bis.read()) != -1) {
                bos.write(aByte);
            }
            bos.flush();
            bos.close();
            bis.close();
            return c_dir + _filename;
        }

        public static Vector getFile(Message pop_message) throws Exception {
            Vector vec = new Vector();
            Object content = pop_message.getContent();
            if (content instanceof Multipart) {
                vec = Tools.getFileHandleMultipart((Multipart)content);
            }
            return vec;
        }

        public static Vector getFileHandleMultipart(Multipart multipart) throws MessagingException, IOException {
            Vector<String> vec = new Vector<String>();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String disposition = part.getDisposition();
                if (disposition == null || !disposition.equals("attachment") && !disposition.equals("inline")) continue;
                String filename = MimeUtility.decodeText((String)part.getFileName());
                String path_filename = Tools.saveFile(filename, part.getInputStream());
                vec.add(path_filename);
            }
            return vec;
        }

        public static Vector getFileEmbed(Message pop_message, String _contentType) throws Exception {
            Vector vec = new Vector();
            Object content = pop_message.getContent();
            if (content instanceof Multipart) {
                vec = Tools.getFileHandleMultipart((Multipart)content, _contentType);
            }
            return vec;
        }

        public static Vector getFileHandleMultipart(Multipart multipart, String _contentType) throws MessagingException, IOException {
            Vector<String> vec = new Vector<String>();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String disposition = part.getDisposition();
                String ctype = part.getContentType();
                ContentType xctype = new ContentType(ctype.toLowerCase());
                if (disposition != null || !xctype.match(_contentType) || part.getFileName() == null) continue;
                String filename = MimeUtility.decodeText((String)part.getFileName());
                String path_filename = Tools.saveFile(filename, part.getInputStream());
                vec.add(path_filename);
            }
            return vec;
        }

        public static String getBody(Message pop_message) throws Exception {
            String body = null;
            Object content = pop_message.getContent();
            body = content instanceof Multipart ? Tools.getBodyHandleMultipart((Multipart)content) : Tools.getBobyHandlePart((Part)pop_message);
            return body;
        }

        public static String getBobyHandlePart(Part part) throws MessagingException, IOException {
            String body = null;
            String ctype = part.getContentType();
            ContentType xctype = new ContentType(ctype.toLowerCase());
            StringBuffer buffer = new StringBuffer();
            if (xctype.match("text/plain") || xctype.match("TEXT/PLAIN")) {
                String xline;
                BufferedReader xreader = Tools.getTextReader(part);
                while ((xline = xreader.readLine()) != null) {
                    buffer.append(xline + '\n');
                }
            } else {
                throw new MessagingException("No text/plain in the message!");
            }
            body = buffer.toString();
            return body;
        }

        public static String getBodyHandleMultipart(Multipart multipart) throws MessagingException, IOException {
            String body = null;
            StringBuffer buffer = new StringBuffer();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                String xline;
                BodyPart part = multipart.getBodyPart(i);
                Object content = part.getContent();
                if (content instanceof Multipart) {
                    body = Tools.getBodyHandleMultipart((Multipart)content);
                    break;
                }
                String disposition = part.getDisposition();
                String ctype = part.getContentType();
                ContentType xctype = new ContentType(ctype.toLowerCase());
                if (!xctype.match("text/plain") && !xctype.match("TEXT/PLAIN") || disposition != null) continue;
                BufferedReader xreader = Tools.getTextReader((Part)part);
                while ((xline = xreader.readLine()) != null) {
                    buffer.append(xline + '\n');
                }
                body = buffer.toString();
            }
            if (body == null) {
                throw new MessagingException("No text/plain in the message!");
            }
            return body;
        }

        public static String getBodyHtml(Message pop_message) throws Exception {
            String body = null;
            Object content = pop_message.getContent();
            if (content instanceof Multipart) {
                body = Tools.getBodyHandleMultipart((Multipart)content, "text/html");
            }
            return body;
        }

        public static String getBodyHandleMultipart(Multipart multipart, String contentType) throws MessagingException, IOException {
            String body = null;
            StringBuffer buffer = new StringBuffer();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                String xline;
                BodyPart part = multipart.getBodyPart(i);
                Object content = part.getContent();
                if (content instanceof Multipart) {
                    body = Tools.getBodyHandleMultipart((Multipart)content, contentType);
                    break;
                }
                String disposition = part.getDisposition();
                String ctype = part.getContentType();
                ContentType xctype = new ContentType(ctype.toLowerCase());
                if (!xctype.match(contentType) || disposition != null) continue;
                BufferedReader xreader = Tools.getTextReader((Part)part);
                while ((xline = xreader.readLine()) != null) {
                    buffer.append(xline + '\n');
                }
                body = buffer.toString();
            }
            if (body == null) {
                throw new MessagingException("No " + contentType + " in the message!");
            }
            return body;
        }

        public static BufferedReader getTextReader(Part part) throws MessagingException {
            try {
                InputStream xis = part.getInputStream();
                String ctype = part.getContentType();
                ContentType xct = new ContentType(ctype.toLowerCase());
                String xjcharset = xct.getParameter("charset");
                xjcharset = xjcharset != null ? MimeUtility.javaCharset((String)xjcharset) : MimeUtility.javaCharset((String)"ASCII");
                InputStreamReader inReader = null;
                try {
                    inReader = new InputStreamReader(xis, xjcharset);
                }
                catch (UnsupportedEncodingException ex) {
                    inReader = null;
                }
                catch (IllegalArgumentException ex) {
                    inReader = null;
                }
                if (inReader == null) {
                    xjcharset = MimeUtility.javaCharset((String)"ASCII");
                    inReader = new InputStreamReader(xis, xjcharset);
                }
                BufferedReader xreader = new BufferedReader(inReader);
                return xreader;
            }
            catch (IOException xex) {
                throw new MessagingException(xex.toString());
            }
        }

        public static void saveELM(MimeMessage mess, File file_dest) throws MessagingException, IOException {
            String message_id = Tools.encodeMessageID(mess.getMessageID());
            if ("".equals(message_id)) {
                message_id = "" + Tools.getMessageID();
            }
            PrintWriter out = new PrintWriter((Writer)new FileWriter(file_dest.getAbsolutePath() + a_sep + message_id + ".eml"), true);
            Enumeration e = mess.getAllHeaders();
            while (e.hasMoreElements()) {
                Header header = (Header)e.nextElement();
                out.println(header.getName() + ": " + header.getValue());
            }
            out.println();
            InputStream in = mess.getInputStream();
            BufferedReader a_br = new BufferedReader(new InputStreamReader(in, "8859_1"));
            String a_str = "";
            String a_strAux = "";
            while ((a_strAux = a_br.readLine()) != null) {
                a_str = a_str + a_strAux + "\n";
            }
            out.println(a_str);
            out.println();
            out.flush();
            out.close();
        }

        public static Long getMessageID() {
            Long c_id = new Long(0L);
            double d = Math.random();
            c_id = new Long((long)(d * 9.223372036854776E18));
            return c_id;
        }

        public static MimeMessage getMimeMessage(String file_eml) throws MessagingException, IOException {
            return Tools.getMimeMessage(new File(file_eml));
        }

        public static MimeMessage getMimeMessage(File f_eml) throws MessagingException, IOException {
            MimeMessage message = null;
            FileInputStream source = new FileInputStream(f_eml);
            message = new MimeMessage(null, (InputStream)source);
            return message;
        }

        public static String encodeMessageID(String str) {
            String res = "";
            if (str == null) {
                return res;
            }
            block10: for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '<': {
                        res = res + "";
                        continue block10;
                    }
                    case '>': {
                        res = res + "";
                        continue block10;
                    }
                    case '\\': {
                        res = res + "";
                        continue block10;
                    }
                    case '/': {
                        res = res + "";
                        continue block10;
                    }
                    case '*': {
                        res = res + "";
                        continue block10;
                    }
                    case '?': {
                        res = res + "";
                        continue block10;
                    }
                    case '|': {
                        res = res + "";
                        continue block10;
                    }
                    case ':': {
                        res = res + "";
                        continue block10;
                    }
                    default: {
                        res = res + c;
                    }
                }
            }
            return res;
        }
    }
}

