/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingContainerPeer;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import sun.awt.CausedFocusEvent;

public class SwingComponentPeer
implements ComponentPeer {
    protected Component awtComponent;
    protected SwingComponent swingComponent;
    protected Font peerFont;
    protected Rectangle paintArea;

    protected SwingComponentPeer() {
    }

    protected void init(Component awtComp, SwingComponent swingComp) {
        JComponent c;
        this.awtComponent = awtComp;
        this.swingComponent = swingComp;
        if (this.swingComponent != null && (c = this.swingComponent.getJComponent()) != null) {
            c.addNotify();
            RepaintManager.currentManager(c).setDoubleBufferingEnabled(false);
            System.setProperty("gnu.awt.swing.doublebuffering", "true");
        }
        if (!(this instanceof LightweightPeer)) {
            Component comp = this.awtComponent;
            Container parent = comp.getParent();
            while (parent != null && !(parent.getPeer() instanceof SwingContainerPeer)) {
                comp = parent;
                parent = comp.getParent();
            }
            if (parent != null && parent.getPeer() instanceof SwingContainerPeer) {
                SwingContainerPeer p = (SwingContainerPeer)parent.getPeer();
                p.addHeavyweightDescendent(this.awtComponent);
            }
        }
    }

    public int checkImage(Image img, int width, int height, ImageObserver ob) {
        return Toolkit.getDefaultToolkit().checkImage(img, width, height, ob);
    }

    public Image createImage(ImageProducer prod) {
        Image image = Toolkit.getDefaultToolkit().createImage(prod);
        return image;
    }

    public Image createImage(int width, int height) {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        return parentPeer.createImage(width, height);
    }

    public void disable() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(false);
        }
    }

    public void dispose() {
        if (!(this instanceof LightweightPeer)) {
            Component comp = this.awtComponent;
            Container parent = comp.getParent();
            while (parent != null && !(parent.getPeer() instanceof SwingContainerPeer)) {
                comp = parent;
                parent = comp.getParent();
            }
            if (parent != null && parent.getPeer() instanceof SwingContainerPeer) {
                SwingContainerPeer p = (SwingContainerPeer)parent.getPeer();
                p.removeHeavyweightDescendent(this.awtComponent);
            }
        }
        this.awtComponent = null;
        this.swingComponent = null;
    }

    public void enable() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(true);
        }
    }

    public ColorModel getColorModel() {
        return null;
    }

    public FontMetrics getFontMetrics(Font f) {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        return parentPeer.getFontMetrics(f);
    }

    public Graphics getGraphics() {
        Container parent = this.awtComponent.getParent();
        Graphics g = parent.getGraphics();
        g.translate(this.awtComponent.getX(), this.awtComponent.getY());
        g.setClip(0, 0, this.awtComponent.getWidth(), this.awtComponent.getHeight());
        return g;
    }

    public Point getLocationOnScreen() {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        Point location = parentPeer.getLocationOnScreen();
        location.x += this.awtComponent.getX();
        location.y += this.awtComponent.getY();
        return location;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AWTEvent e) {
        switch (e.getID()) {
            case 800: 
            case 801: {
                Rectangle clip;
                if (!this.awtComponent.isShowing()) break;
                SwingComponentPeer swingComponentPeer = this;
                synchronized (swingComponentPeer) {
                    this.coalescePaintEvent((PaintEvent)e);
                    assert (this.paintArea != null);
                    clip = this.paintArea;
                    this.paintArea = null;
                }
                Graphics g = this.awtComponent.getGraphics();
                try {
                    g.clipRect(clip.x, clip.y, clip.width, clip.height);
                    this.peerPaint(g, e.getID() == 801);
                    break;
                }
                finally {
                    g.dispose();
                }
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                this.handleMouseEvent((MouseEvent)e);
                break;
            }
            case 503: 
            case 506: {
                this.handleMouseMotionEvent((MouseEvent)e);
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                this.handleKeyEvent((KeyEvent)e);
                break;
            }
            case 1004: 
            case 1005: {
                this.handleFocusEvent((FocusEvent)e);
                break;
            }
        }
    }

    public void hide() {
        Container parent;
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(false);
        }
        if ((parent = this.awtComponent.getParent()) != null) {
            parent.repaint(this.awtComponent.getX(), this.awtComponent.getY(), this.awtComponent.getWidth(), this.awtComponent.getHeight());
        }
    }

    public boolean isFocusTraversable() {
        return this.swingComponent != null ? this.swingComponent.getJComponent().isFocusable() : false;
    }

    public boolean isFocusable() {
        return this.swingComponent != null ? this.swingComponent.getJComponent().isFocusable() : false;
    }

    public Dimension minimumSize() {
        Dimension retVal = this.swingComponent != null ? this.swingComponent.getJComponent().getMinimumSize() : new Dimension(0, 0);
        return retVal;
    }

    public Dimension preferredSize() {
        Dimension retVal = this.swingComponent != null ? this.swingComponent.getJComponent().getPreferredSize() : new Dimension(0, 0);
        return retVal;
    }

    public void paint(Graphics graphics) {
        this.peerPaint(graphics, false);
    }

    public boolean prepareImage(Image img, int width, int height, ImageObserver ob) {
        Container parent = this.awtComponent.getParent();
        if (parent != null) {
            ComponentPeer parentPeer = parent.getPeer();
            return parentPeer.prepareImage(img, width, height, ob);
        }
        return Toolkit.getDefaultToolkit().prepareImage(img, width, height, ob);
    }

    public void print(Graphics graphics) {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().repaint(tm, x, y, width, height);
        } else {
            PaintEvent ev = new PaintEvent(this.awtComponent, 801, new Rectangle(x, y, width, height));
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ev);
        }
    }

    public void requestFocus() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue q = tk.getSystemEventQueue();
        q.postEvent(new FocusEvent(this.awtComponent, 1004, false));
    }

    public boolean requestFocus(Component source, boolean tmp, boolean allowWindowFocus, long tm) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue q = tk.getSystemEventQueue();
        q.postEvent(new FocusEvent(source, 1004, tmp));
        return true;
    }

    public void reshape(int x, int y, int width, int height) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(x, y, width, height);
        }
    }

    public void setBackground(Color color) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBackground(color);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public void setCursor(Cursor cursor) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setCursor(cursor);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(enabled);
        }
    }

    public void setFont(Font font) {
        this.peerFont = font;
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setForeground(color);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(true);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        return parentPeer.getGraphicsConfiguration();
    }

    public void setEventMask(long mask) {
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalescePaintEvent(PaintEvent e) {
        SwingComponentPeer swingComponentPeer = this;
        synchronized (swingComponentPeer) {
            Rectangle newRect = e.getUpdateRect();
            if (this.paintArea == null) {
                this.paintArea = newRect;
            } else {
                Rectangle.union(this.paintArea, newRect, this.paintArea);
            }
        }
    }

    public void updateCursorImmediately() {
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public VolatileImage createVolatileImage(int width, int height) {
        Container parent = this.awtComponent.getParent();
        VolatileImage im = null;
        if (parent != null) {
            ComponentPeer parentPeer = parent.getPeer();
            im = parentPeer.createVolatileImage(width, height);
        }
        return im;
    }

    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        parentPeer.createBuffers(numBuffers, caps);
    }

    public Image getBackBuffer() {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        return parentPeer.getBackBuffer();
    }

    public void flip(BufferCapabilities.FlipContents contents) {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        parentPeer.flip(contents);
    }

    public void destroyBuffers() {
        Container parent = this.awtComponent.getParent();
        ComponentPeer parentPeer = parent.getPeer();
        parentPeer.destroyBuffers();
    }

    public Rectangle getBounds() {
        Rectangle retVal = this.swingComponent != null ? this.swingComponent.getJComponent().getBounds() : new Rectangle();
        return retVal;
    }

    public void reparent(ContainerPeer parent) {
    }

    public void setBounds(int x, int y, int width, int height, int z) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(x, y, width, height);
        }
    }

    public boolean isReparentSupported() {
        return true;
    }

    public void layout() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().doLayout();
        }
    }

    protected void peerPaint(Graphics g, boolean update) {
        this.peerPaintComponent(g);
        Graphics userGraphics = g.create();
        try {
            if (update) {
                this.awtComponent.update(userGraphics);
            } else {
                this.awtComponent.paint(userGraphics);
            }
        }
        finally {
            userGraphics.dispose();
        }
    }

    protected void peerPaintComponent(Graphics g) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().paint(g);
        }
    }

    protected void handleMouseEvent(MouseEvent e) {
        if (this.swingComponent != null) {
            this.swingComponent.handleMouseEvent(e);
        }
    }

    protected void handleMouseMotionEvent(MouseEvent e) {
        if (this.swingComponent != null) {
            this.swingComponent.handleMouseMotionEvent(e);
        }
    }

    protected void handleKeyEvent(KeyEvent e) {
        if (this.swingComponent != null) {
            this.swingComponent.handleKeyEvent(e);
        }
    }

    protected void handleFocusEvent(FocusEvent e) {
        if (this.swingComponent != null) {
            this.swingComponent.handleFocusEvent(e);
        }
    }

    public Component getComponent() {
        return this.awtComponent;
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        return true;
    }
}

