/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCookieManager
implements CookieManager {
    protected Map<String, Map<String, Cookie>> cookies = new HashMap<String, Map<String, Cookie>>();

    @Override
    public void setCookie(Cookie cookie) {
        String domain = cookie.getDomain();
        Map<String, Cookie> map = this.cookies.get(domain);
        if (map == null) {
            map = new HashMap<String, Cookie>();
            this.cookies.put(domain, map);
        }
        String name = cookie.getName();
        map.put(name, cookie);
    }

    @Override
    public Cookie[] getCookies(String host, boolean secure, String path) {
        ArrayList<Cookie> matches = new ArrayList<Cookie>();
        Date now = new Date();
        if (Character.isLetter(host.charAt(0))) {
            int di = host.indexOf(46);
            while (di != -1) {
                this.addCookies(matches, host, secure, path, now);
                host = host.substring(di);
                di = host.indexOf(46, 1);
            }
        }
        this.addCookies(matches, host, secure, path, now);
        Cookie[] ret = new Cookie[matches.size()];
        matches.toArray(ret);
        return ret;
    }

    private void addCookies(ArrayList<Cookie> matches, String domain, boolean secure, String path, Date now) {
        Map<String, Cookie> map = this.cookies.get(domain);
        if (map != null) {
            ArrayList<String> expired = new ArrayList<String>();
            for (Map.Entry<String, Cookie> entry : map.entrySet()) {
                Cookie cookie = entry.getValue();
                Date expires = cookie.getExpiryDate();
                if (expires != null && expires.before(now)) {
                    expired.add(entry.getKey());
                    continue;
                }
                if (secure && !cookie.isSecure() || !path.startsWith(cookie.getPath())) continue;
                matches.add(cookie);
            }
            Iterator i = expired.iterator();
            while (i.hasNext()) {
                map.remove(i.next());
            }
        }
    }
}

