/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.dss.FIPS186;
import gnu.java.security.provider.Gnu;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSSParametersGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final Provider GNU = new Gnu();
    private int modulusLength = -1;
    private SecureRandom rnd;
    private FIPS186 fips;

    protected void engineInit(int size, SecureRandom random) {
        if (size % 64 != 0 || size < 512 || size > 1024) {
            throw new InvalidParameterException("Modulus size/length (in bits) MUST be a multiple of 64, greater than or equal to 512, and less than or equal to 1024");
        }
        this.modulusLength = size;
        this.rnd = random;
    }

    protected void engineInit(AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(spec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Wrong AlgorithmParameterSpec type: " + spec.getClass().getName());
        }
        DSAParameterSpec dsaSpec = (DSAParameterSpec)spec;
        BigInteger p = dsaSpec.getP();
        int size = p.bitLength();
        this.engineInit(size, random);
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.modulusLength < 1) {
            this.modulusLength = 1024;
        }
        this.fips = new FIPS186(this.modulusLength, this.rnd);
        BigInteger[] params = this.fips.generateParameters();
        BigInteger p = params[3];
        BigInteger q = params[2];
        BigInteger g = params[5];
        DSAParameterSpec spec = new DSAParameterSpec(p, q, g);
        AlgorithmParameters result = null;
        try {
            result = AlgorithmParameters.getInstance("dss", GNU);
            result.init(spec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        return result;
    }
}

