/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object();
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakIdentityHashMap() {
        this(11, 0.75f);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[initialCapacity];
    }

    public WeakIdentityHashMap(Map m) {
        this(m.size(), 0.75f);
        this.putAll(m);
    }

    private int hash(Object key) {
        return Math.abs(System.identityHashCode(key) % this.buckets.length);
    }

    void cleanQueue() {
        Reference bucket = this.queue.poll();
        while (bucket != null) {
            this.internalRemove((WeakBucket)bucket);
            bucket = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] oldBuckets = this.buckets;
        int newsize = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newsize * this.loadFactor);
        this.buckets = new WeakBucket[newsize];
        int i = 0;
        while (i < oldBuckets.length) {
            WeakBucket bucket = oldBuckets[i];
            while (bucket != null) {
                WeakBucket nextBucket = bucket.next;
                Object key = bucket.get();
                if (key == null) {
                    bucket.slot = -1;
                    --this.size;
                } else {
                    int slot;
                    bucket.slot = slot = this.hash(key);
                    bucket.next = this.buckets[slot];
                    this.buckets[slot] = bucket;
                }
                bucket = nextBucket;
            }
            ++i;
        }
    }

    private WeakBucket.WeakEntry internalGet(Object key) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = this.buckets[slot];
        while (bucket != null) {
            WeakBucket.WeakEntry entry = bucket.getEntry();
            if (entry != null && key == entry.key) {
                return entry;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private void internalAdd(Object key, Object value) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = new WeakBucket(key, this.queue, value, slot);
        bucket.next = this.buckets[slot];
        this.buckets[slot] = bucket;
        ++this.size;
    }

    void internalRemove(WeakBucket bucket) {
        int slot = bucket.slot;
        if (slot == -1) {
            return;
        }
        bucket.slot = -1;
        WeakBucket prev = null;
        WeakBucket next = this.buckets[slot];
        while (next != bucket) {
            if (next == null) {
                throw new InternalError("WeakIdentityHashMap in inconsistent state");
            }
            prev = next;
            next = prev.next;
        }
        if (prev == null) {
            this.buckets[slot] = bucket.next;
        } else {
            prev.next = bucket.next;
        }
        --this.size;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        this.cleanQueue();
        return this.internalGet(key) != null;
    }

    public Object get(Object key) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        return entry == null ? null : entry.getValue();
    }

    public Object put(Object key, Object value) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry != null) {
            return entry.setValue(value);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(key, value);
        return null;
    }

    public Object remove(Object key) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(entry.getBucket());
        return entry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    public void clear() {
        super.clear();
    }

    public boolean containsValue(Object value) {
        this.cleanQueue();
        return super.containsValue(value);
    }

    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    public void putAll(Map m) {
        super.putAll(m);
    }

    public Collection values() {
        this.cleanQueue();
        return super.values();
    }

    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object key, ReferenceQueue queue, Object value, int slot) {
            super(key, queue);
            this.value = value;
            this.slot = slot;
        }

        WeakEntry getEntry() {
            Object key = this.get();
            if (key == null) {
                return null;
            }
            return new WeakEntry(key);
        }

        class WeakEntry
        implements Map.Entry {
            Object key;

            public WeakEntry(Object key) {
                this.key = key;
            }

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            public Object getKey() {
                return this.key == NULL_KEY ? null : this.key;
            }

            public Object getValue() {
                return WeakBucket.this.value;
            }

            public Object setValue(Object newVal) {
                Object oldVal = WeakBucket.this.value;
                WeakBucket.this.value = newVal;
                return oldVal;
            }

            public int hashCode() {
                return System.identityHashCode(this.key) ^ (WeakBucket.this.value == null ? 0 : WeakBucket.this.value.hashCode());
            }

            public boolean equals(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return this.getKey() == e.getKey() && (WeakBucket.this.value == null ? e.getValue() == null : WeakBucket.this.value.equals(e.getValue()));
                }
                return false;
            }

            public String toString() {
                return this.getKey() + "=" + WeakBucket.this.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        WeakEntrySet() {
        }

        public int size() {
            return WeakIdentityHashMap.this.size;
        }

        public Iterator iterator() {
            return new Iterator(this){
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry;
                int knownMod;
                final /* synthetic */ WeakEntrySet this$1;
                {
                    this.this$1 = weakEntrySet;
                    this.nextEntry = this.findNext(null);
                    this.knownMod = WeakEntrySet.access$0((WeakEntrySet)weakEntrySet).modCount;
                }

                private void checkMod() {
                    WeakEntrySet.access$0(this.this$1).cleanQueue();
                    if (this.knownMod != WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount) {
                        throw new ConcurrentModificationException(String.valueOf(this.knownMod) + " != " + WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount);
                    }
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry lastEntry) {
                    int slot;
                    WeakBucket nextBucket;
                    if (lastEntry != null) {
                        nextBucket = lastEntry.getBucket().next;
                        slot = lastEntry.getBucket().slot;
                    } else {
                        nextBucket = WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets[0];
                        slot = 0;
                    }
                    while (true) {
                        if (nextBucket != null) {
                            WeakBucket.WeakEntry entry = nextBucket.getEntry();
                            if (entry != null) {
                                return entry;
                            }
                            nextBucket = nextBucket.next;
                            continue;
                        }
                        if (++slot == WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets.length) {
                            return null;
                        }
                        nextBucket = WeakEntrySet.access$0((WeakEntrySet)this.this$1).buckets[slot];
                    }
                }

                public boolean hasNext() {
                    this.checkMod();
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++WeakEntrySet.access$0((WeakEntrySet)this.this$1).modCount;
                    WeakEntrySet.access$0(this.this$1).internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }

        static /* synthetic */ WeakIdentityHashMap access$0(WeakEntrySet weakEntrySet) {
            return weakEntrySet.WeakIdentityHashMap.this;
        }
    }
}

