/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.Registry;
import gnu.java.security.hash.HashFactory;
import gnu.javax.crypto.mac.HMac;
import gnu.javax.crypto.mac.IMac;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HMacFactory
implements Registry {
    private HMacFactory() {
    }

    public static IMac getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        if (!(name = name.toLowerCase()).startsWith("hmac-")) {
            return null;
        }
        HMac result = new HMac(HashFactory.getInstance(name = name.substring("hmac-".length()).trim()));
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    public static final Set getNames() {
        Set hashNames = HashFactory.getNames();
        HashSet<String> hs = new HashSet<String>();
        Iterator it = hashNames.iterator();
        while (it.hasNext()) {
            hs.add("hmac-" + (String)it.next());
        }
        return Collections.unmodifiableSet(hs);
    }
}

