/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;
import java.util.Date;

public class PNGTime
extends PNGChunk {
    private Date date;

    protected PNGTime(int type, byte[] data, int crc) throws PNGException {
        super(type, data, crc);
        if (data.length < 7) {
            throw new PNGException("Unexpectedly short time chunk. (" + data.length + " bytes)");
        }
        int year = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int month = data[2] & 0xFF;
        int day = data[3] & 0xFF;
        int hour = data[4] & 0xFF;
        int minute = data[5] & 0xFF;
        int second = data[6] & 0xFF;
        this.date = new Date(year - 1900, month - 1, day, hour, minute, second);
    }

    public PNGTime(Date d) {
        super(1950960965);
        this.data = new byte[7];
        int tmp = d.getYear() + 1900;
        this.data[0] = (byte)((tmp & 0xFF00) >> 8);
        this.data[1] = (byte)(tmp & 0xFF);
        this.data[2] = (byte)(d.getMonth() + 1);
        this.data[3] = (byte)d.getDay();
        this.data[4] = (byte)d.getHours();
        this.data[5] = (byte)d.getMinutes();
        this.data[6] = (byte)d.getSeconds();
    }

    public String toString() {
        return "PNG Time chunk: " + this.date;
    }
}

