/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import gnu.javax.swing.text.html.css.CSSLexicalException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class CSSScanner {
    static final int IDENT = 1;
    static final int ATKEYWORD = 2;
    static final int STRING = 3;
    static final int INVALID = 4;
    static final int HASH = 5;
    static final int NUMBER = 6;
    static final int PERCENTAGE = 7;
    static final int DIMENSION = 8;
    static final int URI = 9;
    static final int UNICODE_RANGE = 10;
    static final int CDO = 11;
    static final int CDC = 12;
    static final int SEMICOLON = 13;
    static final int CURLY_LEFT = 14;
    static final int CURLY_RIGHT = 15;
    static final int PAREN_LEFT = 16;
    static final int PAREN_RIGHT = 17;
    static final int BRACE_LEFT = 16;
    static final int BRACE_RIGHT = 17;
    static final int S = 18;
    static final int COMMENT = 19;
    static final int FUNCTION = 20;
    static final int INCLUDES = 21;
    static final int DASHMATCH = 22;
    static final int DELIM = 23;
    static final int EOF = -1;
    private Reader in;
    char[] parseBuffer;
    int tokenEnd;
    private int[] lookahead = new int[2];

    CSSScanner(Reader r) {
        this.lookahead[0] = -1;
        this.lookahead[1] = -1;
        this.parseBuffer = new char[2048];
        this.in = r;
    }

    int nextToken() throws IOException {
        this.tokenEnd = 0;
        int token = -1;
        int next = this.read();
        if (next != -1) {
            switch (next) {
                case 59: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 13;
                    break;
                }
                case 123: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 14;
                    break;
                }
                case 125: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 15;
                    break;
                }
                case 40: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 16;
                    break;
                }
                case 41: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 17;
                    break;
                }
                case 91: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 16;
                    break;
                }
                case 93: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 17;
                    break;
                }
                case 64: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    this.readIdent();
                    token = 2;
                    break;
                }
                case 35: {
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    this.readName();
                    token = 5;
                    break;
                }
                case 34: 
                case 39: {
                    this.lookahead[0] = next;
                    this.readString();
                    token = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.lookahead[0] = next;
                    this.readWhitespace();
                    token = 18;
                    break;
                }
                case 60: {
                    this.parseBuffer[0] = (char)next;
                    this.parseBuffer[1] = (char)this.read();
                    this.parseBuffer[2] = (char)this.read();
                    this.parseBuffer[3] = (char)this.read();
                    if (this.parseBuffer[1] == '!' && this.parseBuffer[2] == '-' && this.parseBuffer[3] == '-') {
                        token = 11;
                        this.tokenEnd = 4;
                        break;
                    }
                    throw new CSSLexicalException("expected CDO token");
                }
                case 47: {
                    this.lookahead[0] = next;
                    this.readComment();
                    token = 19;
                    break;
                }
                case 126: {
                    this.parseBuffer[0] = (char)next;
                    this.parseBuffer[1] = (char)this.read();
                    if (this.parseBuffer[1] == '=') {
                        token = 21;
                        break;
                    }
                    throw new CSSLexicalException("expected INCLUDES token");
                }
                case 124: {
                    this.parseBuffer[0] = (char)next;
                    this.parseBuffer[1] = (char)this.read();
                    if (this.parseBuffer[1] == '=') {
                        token = 22;
                        break;
                    }
                    throw new CSSLexicalException("expected DASHMATCH token");
                }
                case 45: {
                    int ch2 = this.read();
                    if (ch2 == 45) {
                        int ch3 = this.read();
                        if (ch3 == 62) {
                            this.parseBuffer[0] = (char)next;
                            this.parseBuffer[1] = (char)ch2;
                            this.parseBuffer[2] = (char)ch3;
                            this.tokenEnd = 3;
                            token = 12;
                            break;
                        }
                        throw new CSSLexicalException("expected CDC token");
                    }
                    this.lookahead[0] = next;
                    this.lookahead[1] = ch2;
                    this.readIdent();
                    int ch3 = this.read();
                    if (ch3 == -1 || ch3 != 40) {
                        this.lookahead[0] = ch3;
                        token = 1;
                        break;
                    }
                    this.parseBuffer[this.tokenEnd] = (char)ch3;
                    ++this.tokenEnd;
                    token = 20;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.lookahead[0] = next;
                    this.readNum();
                    int ch3 = this.read();
                    if (ch3 == 37) {
                        this.parseBuffer[this.tokenEnd] = (char)ch3;
                        ++this.tokenEnd;
                        token = 7;
                        break;
                    }
                    if (ch3 == -1 || ch3 != 95 && (ch3 < 97 || ch3 > 122) && (ch3 < 65 || ch3 > 90) && ch3 != 92 && ch3 <= 177) {
                        this.lookahead[0] = ch3;
                        token = 6;
                        break;
                    }
                    this.lookahead[0] = ch3;
                    this.readIdent();
                    token = 8;
                    break;
                }
                default: {
                    if (next == 95 || next >= 97 && next <= 122 || next >= 65 && next <= 90 || next == 92 || next > 177) {
                        this.lookahead[0] = next;
                        this.readIdent();
                        int ch4 = this.read();
                        if (ch4 == -1 || ch4 != 40) {
                            this.lookahead[0] = ch4;
                            token = 1;
                            break;
                        }
                        this.parseBuffer[this.tokenEnd] = (char)ch4;
                        ++this.tokenEnd;
                        token = 20;
                        break;
                    }
                    this.parseBuffer[0] = (char)next;
                    this.tokenEnd = 1;
                    token = 23;
                }
            }
        }
        return token;
    }

    String currentTokenString() {
        return new String(this.parseBuffer, 0, this.tokenEnd);
    }

    private int read() throws IOException {
        int ret;
        if (this.lookahead[0] != -1) {
            ret = this.lookahead[0];
            this.lookahead[0] = -1;
        } else if (this.lookahead[1] != -1) {
            ret = this.lookahead[1];
            this.lookahead[1] = -1;
        } else {
            ret = this.in.read();
        }
        return ret;
    }

    private void readIdent() throws IOException {
        int ch1 = this.read();
        if (ch1 == 45) {
            this.parseBuffer[this.tokenEnd] = (char)ch1;
            ++this.tokenEnd;
            ch1 = this.read();
        }
        if (ch1 == 95 || ch1 >= 97 && ch1 <= 122 || ch1 >= 65 && ch1 <= 90 || ch1 > 177) {
            this.parseBuffer[this.tokenEnd] = (char)ch1;
            ++this.tokenEnd;
        } else if (ch1 == 92) {
            this.lookahead[0] = ch1;
            this.readEscape();
        } else {
            throw new CSSLexicalException("First character of identifier incorrect");
        }
        int ch = this.read();
        while (ch != -1 && (ch == 95 || ch == 45 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57)) {
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
            ch = this.read();
        }
        this.lookahead[0] = ch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readEscape() throws IOException {
        int ch = this.read();
        if (ch == -1 || ch != 92) throw new CSSLexicalException("Escape must start with '\\'");
        this.parseBuffer[this.tokenEnd] = (char)ch;
        ++this.tokenEnd;
        ch = this.read();
        if (ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102) {
            int hexcount = 0;
            ch = this.read();
            while ((ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102) && hexcount < 5) {
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
                ++hexcount;
                ch = this.read();
            }
            if (ch == 13) {
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
                ch = this.read();
                if (ch == 10) {
                    this.parseBuffer[this.tokenEnd] = (char)ch;
                    ++this.tokenEnd;
                    return;
                } else {
                    this.lookahead[0] = ch;
                }
                return;
            } else if (ch == 32 || ch == 10 || ch == 12 || ch == 9) {
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
                return;
            } else {
                this.lookahead[0] = ch;
            }
            return;
        } else {
            if (ch == 10 || ch == 13 || ch == 12) throw new CSSLexicalException("Can't read escape");
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
        }
    }

    private void readName() throws IOException {
        int ch = this.read();
        if (ch != -1 && (ch == 95 || ch == 45 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57)) {
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
        } else {
            throw new CSSLexicalException("Invalid name");
        }
        ch = this.read();
        while (ch != -1 && (ch == 95 || ch == 45 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57)) {
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
            ch = this.read();
        }
        this.lookahead[0] = ch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readString() throws IOException {
        int ch1 = this.read();
        if (ch1 == -1 || ch1 != 39 && ch1 != 34) throw new CSSLexicalException("Invalid string");
        this.parseBuffer[this.tokenEnd] = (char)ch1;
        ++this.tokenEnd;
        int ch = this.read();
        while (ch != -1 && ch != ch1) {
            if (ch != 10 && ch != 13 && ch != 12 && ch != 92) {
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
            } else {
                if (ch != 92) throw new CSSLexicalException("Invalid string");
                int ch2 = this.read();
                if (ch2 == 10 || ch2 == 13) {
                    this.parseBuffer[this.tokenEnd] = (char)ch;
                    this.parseBuffer[this.tokenEnd + 1] = (char)ch2;
                    this.tokenEnd += 2;
                } else {
                    this.lookahead[0] = ch;
                    this.lookahead[1] = ch2;
                    this.readEscape();
                }
            }
            ch = this.read();
        }
        if (ch == -1) throw new CSSLexicalException("Unterminated string");
        this.parseBuffer[this.tokenEnd] = (char)ch;
        ++this.tokenEnd;
    }

    private void readWhitespace() throws IOException {
        int ch = this.read();
        while (ch != -1 && (ch == 32 || ch == 9 || ch == 13 || ch == 10 || ch == 12)) {
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
            ch = this.read();
        }
        this.lookahead[0] = ch;
    }

    private void readURI() throws IOException {
    }

    private void readComment() throws IOException {
        int ch = this.read();
        if (ch != -1 && ch == 47) {
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
            ch = this.read();
            if (ch != -1 && ch == 42) {
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
                ch = this.read();
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
                boolean finished = false;
                int lastChar = ch;
                ch = this.read();
                while (!finished && ch != -1) {
                    if (lastChar == 42 && ch == 47) {
                        finished = true;
                    }
                    this.parseBuffer[this.tokenEnd] = (char)ch;
                    ++this.tokenEnd;
                    lastChar = ch;
                    ch = this.read();
                }
            }
        }
        if (ch == -1) {
            throw new CSSLexicalException("Unterminated comment");
        }
        this.lookahead[0] = ch;
    }

    private void readNum() throws IOException {
        boolean hadDot = false;
        int ch = this.read();
        if (ch != -1 && (ch >= 48 && ch <= 57 || ch == 46)) {
            if (ch == 46) {
                hadDot = true;
            }
            this.parseBuffer[this.tokenEnd] = (char)ch;
            ++this.tokenEnd;
            ch = this.read();
            while (ch != -1 && (ch >= 48 && ch <= 57 || ch == 46 && !hadDot)) {
                if (ch == 46) {
                    hadDot = true;
                }
                this.parseBuffer[this.tokenEnd] = (char)ch;
                ++this.tokenEnd;
                ch = this.read();
            }
        } else {
            throw new CSSLexicalException("Invalid number");
        }
        if (this.parseBuffer[this.tokenEnd - 1] == '.') {
            throw new CSSLexicalException("Invalid number");
        }
        this.lookahead[0] = ch;
    }

    public static void main(String[] args) {
        try {
            int token;
            String name = "/javax/swing/text/html/default.css";
            InputStream in = CSSScanner.class.getResourceAsStream(name);
            BufferedInputStream bin = new BufferedInputStream(in);
            InputStreamReader r = new InputStreamReader(bin);
            CSSScanner s = new CSSScanner(r);
            do {
                token = s.nextToken();
                System.out.println("token: " + token + ": " + s.currentTokenString());
            } while (token != -1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

