/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.Annotation;
import gnu.xml.validation.datatype.Facet;
import gnu.xml.validation.datatype.FractionDigitsFacet;
import gnu.xml.validation.datatype.LengthFacet;
import gnu.xml.validation.datatype.MaxExclusiveFacet;
import gnu.xml.validation.datatype.MaxInclusiveFacet;
import gnu.xml.validation.datatype.MaxLengthFacet;
import gnu.xml.validation.datatype.MinExclusiveFacet;
import gnu.xml.validation.datatype.MinInclusiveFacet;
import gnu.xml.validation.datatype.MinLengthFacet;
import gnu.xml.validation.datatype.PatternFacet;
import gnu.xml.validation.datatype.TotalDigitsFacet;
import gnu.xml.validation.datatype.Type;
import java.util.Set;
import java.util.regex.Matcher;
import javax.xml.namespace.QName;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;

public class SimpleType
extends Type
implements Datatype {
    public static final int ANY = 0;
    public static final int ATOMIC = 1;
    public static final int LIST = 2;
    public static final int UNION = 3;
    public static final int ID_TYPE_NULL = 0;
    public static final int ID_TYPE_ID = 1;
    public static final int ID_TYPE_IDREF = 2;
    public static final int ID_TYPE_IDREFS = 3;
    public final int variety;
    public Set facets;
    public int fundamentalFacets;
    public final SimpleType baseType;
    public final Annotation annotation;

    public SimpleType(QName name, int variety, Set facets, int fundamentalFacets, SimpleType baseType, Annotation annotation) {
        super(name);
        this.variety = variety;
        this.facets = facets;
        this.fundamentalFacets = fundamentalFacets;
        this.baseType = baseType;
        this.annotation = annotation;
    }

    public boolean isValid(String value, ValidationContext context) {
        try {
            this.checkValid(value, context);
            return true;
        }
        catch (DatatypeException datatypeException) {
            return false;
        }
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        if (this.facets != null && !this.facets.isEmpty()) {
            Object parsedValue = this.createValue(value, context);
            for (Facet facet : this.facets) {
                switch (facet.type) {
                    case 1: {
                        LengthFacet lf = (LengthFacet)facet;
                        if (value.length() == lf.value) break;
                        throw new DatatypeException("invalid length");
                    }
                    case 2: {
                        MinLengthFacet nlf = (MinLengthFacet)facet;
                        if (value.length() >= nlf.value) break;
                        throw new DatatypeException("invalid minimum length");
                    }
                    case 3: {
                        MaxLengthFacet xlf = (MaxLengthFacet)facet;
                        if (value.length() <= xlf.value) break;
                        throw new DatatypeException("invalid maximum length");
                    }
                    case 4: {
                        PatternFacet pf = (PatternFacet)facet;
                        Matcher matcher = pf.value.matcher(value);
                        if (matcher.find()) break;
                        throw new DatatypeException("invalid match for pattern");
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        MaxInclusiveFacet xif = (MaxInclusiveFacet)facet;
                        if (xif.matches(parsedValue)) break;
                        throw new DatatypeException("beyond upper bound");
                    }
                    case 8: {
                        MaxExclusiveFacet xef = (MaxExclusiveFacet)facet;
                        if (xef.matches(parsedValue)) break;
                        throw new DatatypeException("beyond upper bound");
                    }
                    case 9: {
                        MinExclusiveFacet nef = (MinExclusiveFacet)facet;
                        if (nef.matches(parsedValue)) break;
                        throw new DatatypeException("beyond lower bound");
                    }
                    case 10: {
                        MinInclusiveFacet nif = (MinInclusiveFacet)facet;
                        if (nif.matches(parsedValue)) break;
                        throw new DatatypeException("beyond lower bound");
                    }
                    case 11: {
                        TotalDigitsFacet tdf = (TotalDigitsFacet)facet;
                        if (SimpleType.countDigits(value, true) <= tdf.value) break;
                        throw new DatatypeException("too many digits");
                    }
                    case 12: {
                        FractionDigitsFacet fdf = (FractionDigitsFacet)facet;
                        if (SimpleType.countDigits(value, false) <= fdf.value) break;
                        throw new DatatypeException("too many fraction digits");
                    }
                }
            }
        }
    }

    private static int countDigits(String value, boolean any) {
        int count = 0;
        int len = value.length();
        boolean seenDecimal = false;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '.') {
                seenDecimal = true;
            } else if (c >= '0' && c <= '9' && (any || seenDecimal)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext context) {
        throw new UnsupportedOperationException();
    }

    public Object createValue(String literal, ValidationContext context) {
        return literal;
    }

    public boolean sameValue(Object value1, Object value2) {
        return value1.equals(value2);
    }

    public int valueHashCode(Object value) {
        return value.hashCode();
    }

    public int getIdType() {
        return 0;
    }

    public boolean isContextDependent() {
        return false;
    }
}

