/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.io.Serializable;

public final class NumericShaper
implements Serializable {
    private static final long serialVersionUID = -8022764705923730308L;
    public static final int ALL_RANGES = 524287;
    public static final int ARABIC = 2;
    public static final int BENGALI = 16;
    public static final int DEVANAGARI = 8;
    public static final int EASTERN_ARABIC = 4;
    public static final int ETHIOPIC = 65536;
    public static final int EUROPEAN = 1;
    public static final int GUJARATI = 64;
    public static final int GURMUKHI = 32;
    public static final int KANNADA = 1024;
    public static final int KHMER = 131072;
    public static final int LAO = 8192;
    public static final int MALAYALAM = 2048;
    public static final int MONGOLIAN = 262144;
    public static final int MYANMAR = 32768;
    public static final int ORIYA = 128;
    public static final int TAMIL = 256;
    public static final int TELUGU = 512;
    public static final int THAI = 4096;
    public static final int TIBETAN = 16384;
    private static final char[] zeroDigits = new char[]{'0', '\u0660', '\u06f0', '\u0966', '\u09e6', '\u0a66', '\u0ae6', '\u0b66', '\u0be6', '\u0c66', '\u0ce6', '\u0d66', '\u0e50', '\u0ed0', '\u0f20', '\u1040', '\u1368', '\u17e0', '\u1810'};
    private int key;
    private int mask;

    private NumericShaper(int key, int mask) {
        this.key = Integer.numberOfTrailingZeros(key);
        this.mask = mask;
    }

    public int getRanges() {
        return this.mask & 0x7FFFF;
    }

    public boolean isContextual() {
        return this.mask > 0;
    }

    public void shape(char[] text, int start, int count) {
        this.shape(text, start, count, 1 << this.key);
    }

    private int classify(Character.UnicodeBlock b) {
        if (b == null) {
            return 0;
        }
        if (b == Character.UnicodeBlock.ARABIC) {
            return 4;
        }
        if (b == Character.UnicodeBlock.BENGALI) {
            return 16;
        }
        if (b == Character.UnicodeBlock.DEVANAGARI) {
            return 8;
        }
        if (b == Character.UnicodeBlock.ETHIOPIC) {
            return 65536;
        }
        if (b == Character.UnicodeBlock.BASIC_LATIN || b == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || b == Character.UnicodeBlock.LATIN_EXTENDED_A || b == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || b == Character.UnicodeBlock.LATIN_EXTENDED_B) {
            return 1;
        }
        if (b == Character.UnicodeBlock.GUJARATI) {
            return 64;
        }
        if (b == Character.UnicodeBlock.GURMUKHI) {
            return 32;
        }
        if (b == Character.UnicodeBlock.KANNADA) {
            return 1024;
        }
        if (b == Character.UnicodeBlock.KHMER) {
            return 131072;
        }
        if (b == Character.UnicodeBlock.LAO) {
            return 8192;
        }
        if (b == Character.UnicodeBlock.MALAYALAM) {
            return 2048;
        }
        if (b == Character.UnicodeBlock.MONGOLIAN) {
            return 262144;
        }
        if (b == Character.UnicodeBlock.MYANMAR) {
            return 32768;
        }
        if (b == Character.UnicodeBlock.ORIYA) {
            return 128;
        }
        if (b == Character.UnicodeBlock.TAMIL) {
            return 256;
        }
        if (b == Character.UnicodeBlock.TELUGU) {
            return 512;
        }
        if (b == Character.UnicodeBlock.THAI) {
            return 4096;
        }
        if (b == Character.UnicodeBlock.TIBETAN) {
            return 16384;
        }
        return 0;
    }

    public void shape(char[] text, int start, int count, int context) {
        int currentContext;
        if (this.isContextual()) {
            if (Integer.bitCount(context) != 1 || (context & 0xFFF80000) != 0) {
                throw new IllegalArgumentException("invalid context argument");
            }
            currentContext = (context & this.mask) == 0 ? -1 : Integer.numberOfTrailingZeros(context);
        } else {
            currentContext = this.key;
        }
        int i = 0;
        while (i < count) {
            char c = text[start + i];
            if (c >= '0' && c <= '9') {
                if (currentContext >= 0 && (c != '0' || 1 << currentContext != 256 && 1 << currentContext != 65536)) {
                    text[start + i] = (char)(zeroDigits[currentContext] + c - 48);
                }
            } else if (this.isContextual()) {
                int group = this.classify(Character.UnicodeBlock.of(c));
                if (group == 4 && (this.mask & 4) == 0 && (this.mask & 2) != 0) {
                    group = 2;
                }
                if ((this.mask & group) != 0) {
                    currentContext = Integer.numberOfTrailingZeros(group);
                }
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NumericShaper)) {
            return false;
        }
        NumericShaper tmp = (NumericShaper)obj;
        return this.key == tmp.key && this.mask == tmp.mask;
    }

    public int hashCode() {
        return this.key ^ this.mask;
    }

    public String toString() {
        return "key=" + this.key + "; mask=" + this.mask;
    }

    public static NumericShaper getShaper(int singleRange) {
        if (Integer.bitCount(singleRange) != 1) {
            throw new IllegalArgumentException("more than one bit set in argument");
        }
        if ((singleRange & 0xFFF80000) != 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        return new NumericShaper(singleRange, Integer.MIN_VALUE | singleRange);
    }

    public static NumericShaper getContextualShaper(int ranges) {
        if ((ranges & 0xFFF80000) != 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        return new NumericShaper(1, ranges);
    }

    public static NumericShaper getContextualShaper(int ranges, int defaultContext) {
        if (Integer.bitCount(defaultContext) != 1) {
            throw new IllegalArgumentException("more than one bit set in context");
        }
        if ((ranges & 0xFFF80000) != 0 || (defaultContext & 0xFFF80000) != 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        return new NumericShaper(defaultContext, ranges);
    }
}

