/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.BeanInfoEmbryo;
import gnu.java.beans.ExplicitBeanInfo;
import gnu.java.beans.IntrospectionIncubator;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.ExplicitInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    static String[] beanInfoSearchPath = new String[]{"gnu.java.beans.info"};
    static Hashtable<Class<?>, BeanInfo> beanInfoCache = new Hashtable();

    private Introspector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        Class<?> clazz = beanClass;
        synchronized (clazz) {
            BeanInfo cachedInfo = beanInfoCache.get(beanClass);
            if (cachedInfo != null) {
                return cachedInfo;
            }
            cachedInfo = Introspector.getBeanInfo(beanClass, null);
            beanInfoCache.put(beanClass, cachedInfo);
            return cachedInfo;
        }
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, int flag) throws IntrospectionException {
        switch (flag) {
            case 1: {
                return Introspector.getBeanInfo(beanClass);
            }
            case 2: {
                Class<?> superclass = beanClass.getSuperclass();
                ExplicitInfo explicit = new ExplicitInfo(superclass, null);
                IntrospectionIncubator ii = new IntrospectionIncubator();
                if (explicit.explicitEventSetDescriptors != null) {
                    ii.setEventStopClass(superclass);
                }
                if (explicit.explicitMethodDescriptors != null) {
                    ii.setMethodStopClass(superclass);
                }
                if (explicit.explicitPropertyDescriptors != null) {
                    ii.setPropertyStopClass(superclass);
                }
                ii.addMethods(beanClass.getMethods());
                BeanInfoEmbryo infoEmbryo = ii.getBeanInfoEmbryo();
                Introspector.merge(infoEmbryo, explicit);
                infoEmbryo.setBeanDescriptor(new BeanDescriptor(beanClass, null));
                return infoEmbryo.getBeanInfo();
            }
        }
        IntrospectionIncubator ii = new IntrospectionIncubator();
        ii.addMethods(beanClass.getMethods());
        BeanInfoEmbryo infoEmbryo = ii.getBeanInfoEmbryo();
        infoEmbryo.setBeanDescriptor(new BeanDescriptor(beanClass, null));
        return infoEmbryo.getBeanInfo();
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        ExplicitInfo.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushFromCaches(Class<?> clz) {
        Class<?> clazz = clz;
        synchronized (clazz) {
            beanInfoCache.remove(clz);
        }
    }

    private static void merge(BeanInfoEmbryo infoEmbryo, ExplicitInfo explicit) {
        MethodDescriptor[] m;
        EventSetDescriptor[] e;
        PropertyDescriptor[] p = explicit.explicitPropertyDescriptors;
        if (p != null) {
            int i = 0;
            while (i < p.length) {
                if (!infoEmbryo.hasProperty(p[i])) {
                    infoEmbryo.addProperty(p[i]);
                }
                ++i;
            }
            if (explicit.defaultProperty > -1) {
                infoEmbryo.setDefaultPropertyName(p[explicit.defaultProperty].getName());
            }
        }
        if ((e = explicit.explicitEventSetDescriptors) != null) {
            int i = 0;
            while (i < e.length) {
                if (!infoEmbryo.hasEvent(e[i])) {
                    infoEmbryo.addEvent(e[i]);
                }
                ++i;
            }
            if (explicit.defaultEvent > -1) {
                infoEmbryo.setDefaultEventName(e[explicit.defaultEvent].getName());
            }
        }
        if ((m = explicit.explicitMethodDescriptors) != null) {
            int i = 0;
            while (i < m.length) {
                if (!infoEmbryo.hasMethod(m[i])) {
                    infoEmbryo.addMethod(m[i]);
                }
                ++i;
            }
        }
        infoEmbryo.setAdditionalBeanInfo(explicit.explicitBeanInfo);
        infoEmbryo.setIcons(explicit.im);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        ExplicitInfo explicit = new ExplicitInfo(beanClass, stopClass);
        IntrospectionIncubator ii = new IntrospectionIncubator();
        ii.setPropertyStopClass(explicit.propertyStopClass);
        ii.setEventStopClass(explicit.eventStopClass);
        ii.setMethodStopClass(explicit.methodStopClass);
        ii.addMethods(beanClass.getMethods());
        BeanInfoEmbryo currentInfo = ii.getBeanInfoEmbryo();
        Introspector.merge(currentInfo, explicit);
        currentInfo.setBeanDescriptor(explicit.explicitBeanDescriptor == null ? new BeanDescriptor(beanClass, null) : explicit.explicitBeanDescriptor);
        return currentInfo.getBeanInfo();
    }

    public static String[] getBeanInfoSearchPath() {
        return beanInfoSearchPath;
    }

    public static void setBeanInfoSearchPath(String[] beanInfoSearchPath) {
        Introspector.beanInfoSearchPath = beanInfoSearchPath;
    }

    public static String decapitalize(String name) {
        try {
            if (!Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            try {
                if (Character.isUpperCase(name.charAt(1))) {
                    return name;
                }
                char[] c = name.toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                return new String(c);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                try {
                    char[] c = new char[]{Character.toLowerCase(name.charAt(0))};
                    return new String(c);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException2) {
                    return name;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static BeanInfo copyBeanInfo(BeanInfo b) {
        Image[] icons = new Image[4];
        int i = 1;
        while (i <= 4) {
            icons[i - 1] = b.getIcon(i);
            ++i;
        }
        return new ExplicitBeanInfo(b.getBeanDescriptor(), b.getAdditionalBeanInfo(), b.getPropertyDescriptors(), b.getDefaultPropertyIndex(), b.getEventSetDescriptors(), b.getDefaultEventIndex(), b.getMethodDescriptors(), icons);
    }
}

