/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;

public abstract class InputStream
implements Closeable {
    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < len) {
            try {
                int ch = this.read();
                if (ch < 0) {
                    return i == 0 ? -1 : i;
                }
                b[off + i] = (byte)ch;
            }
            catch (IOException ex) {
                if (i == 0) {
                    throw ex;
                }
                return i;
            }
            ++i;
        }
        return i;
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public long skip(long n) throws IOException {
        int buflen = n > 2048L ? 2048 : (int)n;
        byte[] tmpbuf = new byte[buflen];
        long origN = n;
        while (n > 0L) {
            int numread = this.read(tmpbuf, 0, n > (long)buflen ? buflen : (int)n);
            if (numread <= 0) break;
            n -= (long)numread;
        }
        return origN - n;
    }
}

