/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;

public class CertPathValidator {
    private static final String CERT_PATH_VALIDATOR = "CertPathValidator";
    private final CertPathValidatorSpi validatorSpi;
    private final Provider provider;
    private final String algorithm;

    protected CertPathValidator(CertPathValidatorSpi validatorSpi, Provider provider, String algorithm) {
        this.validatorSpi = validatorSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static synchronized String getDefaultType() {
        String type = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("certpathvalidator.type");
            }
        });
        if (type == null) {
            type = "PKIX";
        }
        return type;
    }

    public static CertPathValidator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return CertPathValidator.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static CertPathValidator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CertPathValidator.getInstance(algorithm, p);
    }

    public static CertPathValidator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        CPStringBuilder sb = new CPStringBuilder("CertPathValidator for algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(CERT_PATH_VALIDATOR, algorithm, provider);
            return new CertPathValidator((CertPathValidatorSpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathValidatorResult validate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        return this.validatorSpi.engineValidate(certPath, params);
    }
}

