/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeType
extends OpenType<CompositeData> {
    private static final long serialVersionUID = -5366242454346948798L;
    private TreeMap<String, String> nameToDescription;
    private TreeMap<String, OpenType<?>> nameToType;
    private transient Integer hashCode;
    private transient String string;

    public CompositeType(String name, String desc, String[] names, String[] descs, OpenType<?>[] types) throws OpenDataException {
        super(CompositeData.class.getName(), name, desc);
        if (names.length == 0 || names.length != descs.length || names.length != types.length) {
            throw new IllegalArgumentException("Arrays must be non-empty and of equal size.");
        }
        this.nameToDescription = new TreeMap();
        int a = 0;
        while (a < names.length) {
            if (names[a] == null) {
                throw new IllegalArgumentException("Name " + a + " is null.");
            }
            if (descs[a] == null) {
                throw new IllegalArgumentException("Description " + a + " is null.");
            }
            String fieldName = names[a].trim();
            if (fieldName.length() == 0) {
                throw new IllegalArgumentException("Name " + a + " is " + "the empty string.");
            }
            if (descs[a].length() == 0) {
                throw new IllegalArgumentException("Description " + a + " is " + "the empty string.");
            }
            if (this.nameToDescription.containsKey(fieldName)) {
                throw new OpenDataException(String.valueOf(fieldName) + " appears more " + "than once.");
            }
            this.nameToDescription.put(fieldName, descs[a]);
            ++a;
        }
        this.nameToType = new TreeMap();
        a = 0;
        while (a < names.length) {
            this.nameToType.put(names[a].trim(), types[a]);
            ++a;
        }
    }

    public boolean containsKey(String name) {
        return this.nameToDescription.containsKey(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeType)) {
            return false;
        }
        CompositeType ctype = (CompositeType)obj;
        if (!ctype.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        Set<String> keys = this.keySet();
        if (!ctype.keySet().equals(keys)) {
            return false;
        }
        for (String key : keys) {
            if (ctype.getType(key).equals(this.getType(key))) continue;
            return false;
        }
        return true;
    }

    public String getDescription(String name) {
        return this.nameToDescription.get(name);
    }

    public OpenType<?> getType(String name) {
        return this.nameToType.get(name);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int elementTotal = 0;
            for (Map.Entry<String, OpenType<?>> entry : this.nameToType.entrySet()) {
                elementTotal += entry.getKey().hashCode() + entry.getValue().hashCode();
            }
            this.hashCode = elementTotal + this.getTypeName().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj instanceof CompositeData) {
            CompositeData data = (CompositeData)obj;
            return this.equals(data.getCompositeType());
        }
        return false;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[name=" + this.getTypeName() + ", fields=" + this.nameToType + "]";
        }
        return this.string;
    }
}

