/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;

public class KeyManagerFactory {
    private static final String KEY_MANAGER_FACTORY = "KeyManagerFactory";
    private static final String DEFAULT_ALGORITHM = "JessieX509";
    private final KeyManagerFactorySpi kmfSpi;
    private final Provider provider;
    private final String algorithm;

    protected KeyManagerFactory(KeyManagerFactorySpi kmfSpi, Provider provider, String algorithm) {
        this.kmfSpi = kmfSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final String getDefaultAlgorithm() {
        String alg = null;
        try {
            alg = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.KeyManagerFactory.algorithm");
                }
            });
        }
        catch (SecurityException securityException) {}
        if (alg == null) {
            alg = DEFAULT_ALGORITHM;
        }
        return alg;
    }

    public static final KeyManagerFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return KeyManagerFactory.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static final KeyManagerFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyManagerFactory.getInstance(algorithm, p);
    }

    public static final KeyManagerFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("KeyManagerFactory algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(KEY_MANAGER_FACTORY, algorithm, provider);
            return new KeyManagerFactory((KeyManagerFactorySpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final KeyManager[] getKeyManagers() {
        return this.kmfSpi.engineGetKeyManagers();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        this.kmfSpi.engineInit(params);
    }

    public final void init(KeyStore store, char[] passwd) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.kmfSpi.engineInit(store, passwd);
    }
}

