/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import gnu.classpath.NotImplementedException;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

class UnixFileSystemView
extends FileSystemView {
    private static final String NEW_FOLDER_NAME = "NewFolder";

    UnixFileSystemView() {
    }

    public File createNewFolder(File containingDir) throws IOException {
        int count = 0;
        File f = null;
        String filename = String.valueOf(containingDir.getAbsolutePath()) + File.separator + NEW_FOLDER_NAME;
        while (f == null) {
            String full = filename;
            if (count > 0) {
                full = String.valueOf(full) + "." + count++;
            }
            if (!(f = new File(full)).isDirectory() && !f.isFile()) continue;
            ++count;
            f = null;
        }
        f.mkdir();
        return f;
    }

    public File[] getRoots() {
        return File.listRoots();
    }

    public String getSystemDisplayName(File f) {
        String name = null;
        if (f != null) {
            if (this.isRoot(f)) {
                name = f.getAbsolutePath();
            } else {
                try {
                    String path = f.getCanonicalPath();
                    name = path.substring(path.lastIndexOf(File.separator) + 1);
                }
                catch (IOException iOException) {
                    name = f.getName();
                }
            }
        }
        return name;
    }

    public Icon getSystemIcon(File f) throws NotImplementedException {
        return null;
    }

    public String getSystemTypeDescription(File f) throws NotImplementedException {
        return null;
    }

    public boolean isRoot(File f) {
        return this.isFileSystemRoot(f);
    }
}

