/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    protected KeyStroke closeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke minimizeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    protected DesktopManager desktopManager;
    protected JDesktopPane desktop;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDesktopPaneUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    protected void installDefaults() {
        Color bg = this.desktop.getBackground();
        if (bg == null || bg instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("desktop"));
        }
    }

    protected void installDesktopManager() {
        this.desktopManager = new DefaultDesktopManager();
        this.desktop.setDesktopManager(this.desktopManager);
    }

    protected void installKeyboardActions() {
        this.registerKeyboardActions();
    }

    public void installUI(JComponent c) {
        if (c instanceof JDesktopPane) {
            this.desktop = (JDesktopPane)c;
            this.installDefaults();
            this.installDesktopManager();
            this.installKeyboardActions();
        }
    }

    protected void registerKeyboardActions() {
    }

    protected void uninstallDefaults() {
        this.desktop.setBackground(null);
    }

    protected void uninstallDesktopManager() {
        this.desktopManager = null;
        this.desktop.setDesktopManager(null);
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
    }

    protected void unregisterKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                try {
                    BasicDesktopPaneUI.this.desktop.getSelectedFrame().setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                return BasicDesktopPaneUI.this.desktop.getSelectedFrame().isClosable();
            }
            return false;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                try {
                    BasicDesktopPaneUI.this.desktop.getSelectedFrame().setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                return BasicDesktopPaneUI.this.desktop.getSelectedFrame().isMaximizable();
            }
            return false;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                try {
                    BasicDesktopPaneUI.this.desktop.getSelectedFrame().setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                return BasicDesktopPaneUI.this.desktop.getSelectedFrame().isIconifiable();
            }
            return false;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] frames = BasicDesktopPaneUI.this.desktop.getAllFrames();
            if (frames.length == 0) {
                return;
            }
            JInternalFrame sFrame = frames[0];
            if (BasicDesktopPaneUI.this.desktop.getSelectedFrame() != null) {
                sFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            }
            int i = 0;
            while (i < frames.length) {
                if (frames[i] == sFrame) break;
                ++i;
            }
            if (i == frames.length) {
                i = 0;
            }
            BasicDesktopPaneUI.this.desktop.setSelectedFrame(frames[i]);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame frame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (frame != null) {
                try {
                    if (frame.isIcon()) {
                        frame.setIcon(false);
                    } else if (frame.isMaximum()) {
                        frame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

