/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    protected Icon icon;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRadioButtonUI();
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.icon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "icon");
    }

    protected String getPropertyPrefix() {
        return "RadioButton.";
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension size = c.getSize();
        Insets i = b.getInsets();
        BasicRadioButtonUI.textR.x = 0;
        BasicRadioButtonUI.textR.y = 0;
        BasicRadioButtonUI.textR.width = 0;
        BasicRadioButtonUI.textR.height = 0;
        BasicRadioButtonUI.iconR.x = 0;
        BasicRadioButtonUI.iconR.y = 0;
        BasicRadioButtonUI.iconR.width = 0;
        BasicRadioButtonUI.iconR.height = 0;
        BasicRadioButtonUI.viewR.x = i.left;
        BasicRadioButtonUI.viewR.y = i.right;
        BasicRadioButtonUI.viewR.width = size.width - i.left - i.right;
        BasicRadioButtonUI.viewR.height = size.height - i.top - i.bottom;
        Font f = c.getFont();
        g.setFont(f);
        Icon icon = b.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        Icon currentIcon = this.getCurrentIcon(b);
        String text = SwingUtilities.layoutCompoundLabel(c, g.getFontMetrics(f), b.getText(), currentIcon == null ? this.getDefaultIcon() : currentIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, b.getIconTextGap());
        if (currentIcon != null) {
            currentIcon.paintIcon(c, g, BasicRadioButtonUI.iconR.x, BasicRadioButtonUI.iconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textR);
            } else {
                this.paintText(g, b, textR, text);
            }
            if (b.hasFocus() && b.isFocusPainted() && BasicRadioButtonUI.textR.width > 0 && BasicRadioButtonUI.textR.height > 0) {
                this.paintFocus(g, textR, size);
            }
        }
    }

    private Icon getCurrentIcon(AbstractButton b) {
        ButtonModel m = b.getModel();
        Icon currentIcon = b.getIcon();
        if (currentIcon == null) {
            currentIcon = this.getDefaultIcon();
        } else {
            if (!m.isEnabled()) {
                currentIcon = m.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (m.isPressed() && m.isArmed()) {
                currentIcon = b.getPressedIcon();
                if (currentIcon == null) {
                    currentIcon = b.getSelectedIcon();
                }
            } else if (m.isSelected()) {
                if (b.isRolloverEnabled() && m.isRollover()) {
                    currentIcon = b.getRolloverSelectedIcon();
                    if (currentIcon == null) {
                        currentIcon = b.getSelectedIcon();
                    }
                } else {
                    currentIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && m.isRollover()) {
                currentIcon = b.getRolloverIcon();
            }
            if (currentIcon == null) {
                currentIcon = b.getIcon();
            }
        }
        return currentIcon;
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Insets insets = b.getInsets();
        String text = b.getText();
        Icon i = b.getIcon();
        if (i == null) {
            i = this.getDefaultIcon();
        }
        BasicRadioButtonUI.textR.x = 0;
        BasicRadioButtonUI.textR.y = 0;
        BasicRadioButtonUI.textR.width = 0;
        BasicRadioButtonUI.textR.height = 0;
        BasicRadioButtonUI.iconR.x = 0;
        BasicRadioButtonUI.iconR.y = 0;
        BasicRadioButtonUI.iconR.width = 0;
        BasicRadioButtonUI.iconR.height = 0;
        BasicRadioButtonUI.viewR.x = 0;
        BasicRadioButtonUI.viewR.y = 0;
        BasicRadioButtonUI.viewR.width = Short.MAX_VALUE;
        BasicRadioButtonUI.viewR.height = Short.MAX_VALUE;
        SwingUtilities.layoutCompoundLabel(b, b.getFontMetrics(b.getFont()), text, i, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        Rectangle r = SwingUtilities.computeUnion(BasicRadioButtonUI.textR.x, BasicRadioButtonUI.textR.y, BasicRadioButtonUI.textR.width, BasicRadioButtonUI.textR.height, iconR);
        return new Dimension(insets.left + r.width + insets.right, insets.top + r.height + insets.bottom);
    }

    protected void paintFocus(Graphics g, Rectangle tr, Dimension size) {
        Color focusColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + ".focus");
        Color saved = g.getColor();
        g.setColor(focusColor);
        g.drawRect(tr.x, tr.y, tr.width, tr.height);
        g.setColor(saved);
    }
}

