/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private PropertyChangeListener listener = this.createPropertyChangeListener();

    public static ComponentUI createUI(JComponent c) {
        return new BasicSpinnerUI();
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    protected LayoutManager createLayout() {
        return new DefaultLayoutManager();
    }

    protected Component createNextButton() {
        BasicArrowButton button = new BasicArrowButton(1);
        return button;
    }

    protected Component createPreviousButton() {
        BasicArrowButton button = new BasicArrowButton(5);
        return button;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("editor".equals(event.getPropertyName())) {
                    BasicSpinnerUI.this.replaceEditor((JComponent)event.getOldValue(), (JComponent)event.getNewValue());
                }
            }
        };
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        JComponent e = this.spinner.getEditor();
        if (e instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor de = (JSpinner.DefaultEditor)e;
            de.getTextField().setBorder(null);
        }
        this.spinner.setLayout(this.createLayout());
        this.spinner.setOpaque(true);
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(this.listener);
    }

    protected void installNextButtonListeners(Component c) {
        c.addMouseListener(new MouseAdapter(){
            volatile boolean mouseDown;
            Timer timer = new Timer(50, new ActionListener(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void actionPerformed(ActionEvent event) {
                    this.this$1.increment();
                }
            });

            public void mousePressed(MouseEvent evt) {
                if (!BasicSpinnerUI.this.spinner.isEnabled()) {
                    return;
                }
                this.increment();
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public void mouseReleased(MouseEvent evt) {
                this.timer.stop();
            }

            void increment() {
                Object next = BasicSpinnerUI.this.spinner.getNextValue();
                if (next != null) {
                    BasicSpinnerUI.this.spinner.getModel().setValue(next);
                }
            }
        });
    }

    protected void installPreviousButtonListeners(Component c) {
        c.addMouseListener(new MouseAdapter(){
            volatile boolean mouseDown;
            Timer timer = new Timer(50, new ActionListener(this){
                final /* synthetic */ 4 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void actionPerformed(ActionEvent event) {
                    this.this$1.decrement();
                }
            });

            public void mousePressed(MouseEvent evt) {
                if (!BasicSpinnerUI.this.spinner.isEnabled()) {
                    return;
                }
                this.decrement();
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public void mouseReleased(MouseEvent evt) {
                this.timer.stop();
            }

            void decrement() {
                Object prev = BasicSpinnerUI.this.spinner.getPreviousValue();
                if (prev != null) {
                    BasicSpinnerUI.this.spinner.getModel().setValue(prev);
                }
            }
        });
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.spinner = (JSpinner)c;
        this.installDefaults();
        this.installListeners();
        Component next = this.createNextButton();
        Component previous = this.createPreviousButton();
        this.installNextButtonListeners(next);
        this.installPreviousButtonListeners(previous);
        c.add((Component)this.createEditor(), "Editor");
        c.add(next, "Next");
        c.add(previous, "Previous");
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.spinner.add(newEditor);
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(this.listener);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults();
        this.uninstallListeners();
        c.removeAll();
    }

    private class DefaultLayoutManager
    implements LayoutManager {
        private Component editor;
        private Component next;
        private Component previous;

        private DefaultLayoutManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets i = parent.getInsets();
                boolean l2r = parent.getComponentOrientation().isLeftToRight();
                Dimension e = this.prefSize(this.editor);
                Dimension n = this.prefSize(this.next);
                Dimension p = this.prefSize(this.previous);
                Dimension s = parent.getSize();
                int x = l2r ? i.left : i.right;
                int y = i.top;
                int w = Math.max(p.width, n.width);
                int h = (s.height - i.bottom) / 2;
                int e_width = s.width - w - i.left - i.right;
                if (l2r) {
                    this.setBounds(this.editor, x, y, e_width, 2 * h);
                    this.setBounds(this.next, x += e_width, y, w, h);
                    this.setBounds(this.previous, x, y += h, w, h);
                } else {
                    this.setBounds(this.next, x, y + (s.height - e.height) / 2, w, h);
                    this.setBounds(this.previous, x, (y += h) + (s.height - e.height) / 2, w, h);
                    this.setBounds(this.editor, x += w, y -= h, e_width, e.height);
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tmp;
            Dimension d = new Dimension();
            if (this.editor != null) {
                Dimension tmp2 = this.editor.getMinimumSize();
                d.width += tmp2.width;
                d.height = tmp2.height;
            }
            int nextWidth = 0;
            int previousWidth = 0;
            if (this.next != null) {
                tmp = this.next.getMinimumSize();
                nextWidth = tmp.width;
            }
            if (this.previous != null) {
                tmp = this.previous.getMinimumSize();
                previousWidth = tmp.width;
            }
            d.width += Math.max(nextWidth, previousWidth);
            return d;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tmp;
            Dimension d = new Dimension();
            if (this.editor != null) {
                Dimension tmp2 = this.editor.getPreferredSize();
                d.width += Math.max(tmp2.width, 40);
                d.height = tmp2.height;
            }
            int nextWidth = 0;
            int previousWidth = 0;
            if (this.next != null) {
                tmp = this.next.getPreferredSize();
                nextWidth = tmp.width;
            }
            if (this.previous != null) {
                tmp = this.previous.getPreferredSize();
                previousWidth = tmp.width;
            }
            d.width += Math.max(nextWidth, previousWidth);
            Insets insets = parent.getInsets();
            d.width = d.width + insets.left + insets.right;
            d.height = d.height + insets.top + insets.bottom;
            return d;
        }

        public void removeLayoutComponent(Component child) {
            if (child == this.editor) {
                this.editor = null;
            } else if (child == this.next) {
                this.next = null;
            } else if (this.previous == child) {
                this.previous = null;
            }
        }

        public void addLayoutComponent(String name, Component child) {
            if ("Editor".equals(name)) {
                this.editor = child;
            } else if ("Next".equals(name)) {
                this.next = child;
            } else if ("Previous".equals(name)) {
                this.previous = child;
            }
        }

        private Dimension prefSize(Component c) {
            if (c == null) {
                return new Dimension();
            }
            return c.getPreferredSize();
        }

        private void setBounds(Component c, int x, int y, int w, int h) {
            if (c != null) {
                c.setBounds(x, y, w, h);
            }
        }
    }
}

