/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicTableUI
extends TableUI {
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    protected JTable table;
    Border cellBorder;
    TableAction action;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        return new BasicTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    public Dimension getMaximumSize(JComponent comp) {
        int maxTotalColumnWidth = 0;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            maxTotalColumnWidth += this.table.getColumnModel().getColumn(i).getMaxWidth();
            ++i;
        }
        return new Dimension(maxTotalColumnWidth, this.getHeight());
    }

    public Dimension getMinimumSize(JComponent comp) {
        int minTotalColumnWidth = 0;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            minTotalColumnWidth += this.table.getColumnModel().getColumn(i).getMinWidth();
            ++i;
        }
        return new Dimension(minTotalColumnWidth, this.getHeight());
    }

    public Dimension getPreferredSize(JComponent comp) {
        int prefTotalColumnWidth = 0;
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount()) {
            TableColumn col = tcm.getColumn(i);
            prefTotalColumnWidth += col.getPreferredWidth();
            ++i;
        }
        return new Dimension(prefTotalColumnWidth, this.getHeight());
    }

    private int getHeight() {
        int height = 0;
        int rowCount = this.table.getRowCount();
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, 0, true);
            height = r.y + r.height;
        }
        return height;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        this.table.setOpaque(true);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)SharedUIDefaults.get("Table.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.table, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap am = (ActionMap)UIManager.get("Table.actionMap");
        if (am == null) {
            am = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("Table.actionMap", am);
        }
        return am;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        TableAction action = new TableAction();
        am.put("cut", TransferHandler.getCutAction());
        am.put("copy", TransferHandler.getCopyAction());
        am.put("paste", TransferHandler.getPasteAction());
        am.put("cancel", action);
        am.put("selectAll", action);
        am.put("clearSelection", action);
        am.put("startEditing", action);
        am.put("selectNextRow", action);
        am.put("selectNextRowCell", action);
        am.put("selectNextRowExtendSelection", action);
        am.put("selectNextRowChangeLead", action);
        am.put("selectPreviousRow", action);
        am.put("selectPreviousRowCell", action);
        am.put("selectPreviousRowExtendSelection", action);
        am.put("selectPreviousRowChangeLead", action);
        am.put("selectNextColumn", action);
        am.put("selectNextColumnCell", action);
        am.put("selectNextColumnExtendSelection", action);
        am.put("selectNextColumnChangeLead", action);
        am.put("selectPreviousColumn", action);
        am.put("selectPreviousColumnCell", action);
        am.put("selectPreviousColumnExtendSelection", action);
        am.put("selectPreviousColumnChangeLead", action);
        am.put("scrollLeftChangeSelection", action);
        am.put("scrollLeftExtendSelection", action);
        am.put("scrollRightChangeSelection", action);
        am.put("scrollRightExtendSelection", action);
        am.put("scrollUpChangeSelection", action);
        am.put("scrollUpExtendSelection", action);
        am.put("scrollDownChangeSelection", action);
        am.put("scrolldownExtendSelection", action);
        am.put("selectFirstColumn", action);
        am.put("selectFirstColumnExtendSelection", action);
        am.put("selectLastColumn", action);
        am.put("selectLastColumnExtendSelection", action);
        am.put("selectFirstRow", action);
        am.put("selectFirstRowExtendSelection", action);
        am.put("selectLastRow", action);
        am.put("selectLastRowExtendSelection", action);
        am.put("addToSelection", action);
        am.put("toggleAndAnchor", action);
        am.put("extendTo", action);
        am.put("moveSelectionTo", action);
        return am;
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.table.addFocusListener(this.focusListener);
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        this.table.addKeyListener(this.keyListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeHandler();
        }
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void installUI(JComponent comp) {
        this.table = (JTable)comp;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    void paintCell(Graphics g, int row, int col, Rectangle bounds, TableCellRenderer rend) {
        Component comp = this.table.prepareRenderer(rend, row, col);
        this.rendererPane.paintComponent(g, comp, this.table, bounds);
    }

    public void paint(Graphics gfx, JComponent ignored) {
        int rn;
        Point p2;
        int cn;
        int r0;
        int ncols = this.table.getColumnCount();
        int nrows = this.table.getRowCount();
        if (nrows == 0 || ncols == 0) {
            return;
        }
        Rectangle clip = gfx.getClipBounds();
        Point p1 = new Point(clip.x, clip.y);
        int c0 = this.table.columnAtPoint(p1);
        if (c0 == -1) {
            c0 = 0;
        }
        if ((r0 = this.table.rowAtPoint(p1)) == -1) {
            r0 = 0;
        }
        if ((cn = this.table.columnAtPoint(p2 = new Point(clip.x + clip.width, clip.y + clip.height))) == -1) {
            cn = this.table.getColumnCount() - 1;
        }
        if ((rn = this.table.rowAtPoint(p2)) == -1) {
            rn = this.table.getRowCount() - 1;
        }
        int columnMargin = this.table.getColumnModel().getColumnMargin();
        int rowMargin = this.table.getRowMargin();
        TableColumnModel cmodel = this.table.getColumnModel();
        int[] widths = new int[cn + 1];
        int i = c0;
        while (i <= cn) {
            widths[i] = cmodel.getColumn(i).getWidth() - columnMargin;
            ++i;
        }
        Rectangle bounds = this.table.getCellRect(r0, c0, false);
        int left = bounds.x;
        int top = bounds.y;
        Color grid = this.table.getGridColor();
        int r = r0;
        while (r <= rn) {
            int c = c0;
            while (c <= cn) {
                bounds.width = widths[c];
                this.paintCell(gfx, r, c, bounds, this.table.getCellRenderer(r, c));
                bounds.x += widths[c] + columnMargin;
                ++c;
            }
            bounds.x = left;
            bounds.y += this.table.getRowHeight(r);
            bounds.height = this.table.getRowHeight(r + 1) - rowMargin;
            ++r;
        }
        int bottom = bounds.y - rowMargin;
        if (grid != null && this.table.getShowVerticalLines()) {
            Color save = gfx.getColor();
            gfx.setColor(grid);
            int x = left - columnMargin;
            int c = c0;
            while (c <= cn) {
                gfx.drawLine(x += widths[c] + columnMargin, top, x, bottom);
                ++c;
            }
            gfx.setColor(save);
        }
        if (grid != null && this.table.getShowHorizontalLines()) {
            Color save = gfx.getColor();
            gfx.setColor(grid);
            int y = top - rowMargin;
            int r2 = r0;
            while (r2 <= rn) {
                gfx.drawLine(left, y += this.table.getRowHeight(r2), p2.x, y);
                ++r2;
            }
            gfx.setColor(save);
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            this.repaintLeadCell();
        }

        public void focusLost(FocusEvent e) {
            this.repaintLeadCell();
        }

        private void repaintLeadCell() {
            int rowCount = BasicTableUI.this.table.getRowCount();
            int columnCount = BasicTableUI.this.table.getColumnCount();
            int rowLead = BasicTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
            int columnLead = BasicTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (rowLead >= 0 && rowLead < rowCount && columnLead >= 0 && columnLead < columnCount) {
                Rectangle dirtyRect = BasicTableUI.this.table.getCellRect(rowLead, columnLead, false);
                BasicTableUI.this.table.repaint(dirtyRect);
            }
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyTyped(KeyEvent event) {
            int c;
            int r;
            if (!BasicTableUI.this.table.isEditing() && BasicTableUI.this.table.isEnabled() && BasicTableUI.this.table.isCellEditable(r = BasicTableUI.this.table.getSelectedRow(), c = BasicTableUI.this.table.getSelectedColumn())) {
                BasicTableUI.this.table.editCellAt(r, c);
            }
        }

        public void keyPressed(KeyEvent event) {
        }

        public void keyReleased(KeyEvent event) {
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        Point begin;
        Point curr;

        private void updateSelection(boolean controlPressed) {
            int lo_row = BasicTableUI.this.table.rowAtPoint(this.begin);
            int hi_row = BasicTableUI.this.table.rowAtPoint(this.curr);
            ListSelectionModel rowModel = BasicTableUI.this.table.getSelectionModel();
            if (lo_row != -1 && hi_row != -1) {
                if (controlPressed && rowModel.getSelectionMode() != 0) {
                    rowModel.addSelectionInterval(lo_row, hi_row);
                } else {
                    rowModel.setSelectionInterval(lo_row, hi_row);
                }
            }
            int lo_col = BasicTableUI.this.table.columnAtPoint(this.begin);
            int hi_col = BasicTableUI.this.table.columnAtPoint(this.curr);
            ListSelectionModel colModel = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            if (lo_col != -1 && hi_col != -1) {
                if (controlPressed && colModel.getSelectionMode() != 0) {
                    colModel.addSelectionInterval(lo_col, hi_col);
                } else {
                    colModel.setSelectionInterval(lo_col, hi_col);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            int col;
            Point p = e.getPoint();
            int row = BasicTableUI.this.table.rowAtPoint(p);
            if (BasicTableUI.this.table.isCellEditable(row, col = BasicTableUI.this.table.columnAtPoint(p))) {
                TableCellEditor editor = BasicTableUI.this.table.getCellEditor(row, col);
                if (editor instanceof DefaultCellEditor) {
                    DefaultCellEditor ce = (DefaultCellEditor)editor;
                    if (e.getClickCount() < ce.getClickCountToStart()) {
                        return;
                    }
                }
                BasicTableUI.this.table.editCellAt(row, col);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (BasicTableUI.this.table.isEnabled()) {
                this.curr = new Point(e.getX(), e.getY());
                this.updateSelection(e.isControlDown());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (BasicTableUI.this.table.isEnabled()) {
                ListSelectionModel rowModel = BasicTableUI.this.table.getSelectionModel();
                ListSelectionModel colModel = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                int rowLead = rowModel.getLeadSelectionIndex();
                int colLead = colModel.getLeadSelectionIndex();
                this.begin = new Point(e.getX(), e.getY());
                this.curr = new Point(e.getX(), e.getY());
                if (e.isControlDown() && BasicTableUI.this.table.isCellSelected(BasicTableUI.this.table.rowAtPoint(this.begin), BasicTableUI.this.table.columnAtPoint(this.begin))) {
                    BasicTableUI.this.table.getSelectionModel().removeSelectionInterval(BasicTableUI.this.table.rowAtPoint(this.begin), BasicTableUI.this.table.rowAtPoint(this.begin));
                    BasicTableUI.this.table.getColumnModel().getSelectionModel().removeSelectionInterval(BasicTableUI.this.table.columnAtPoint(this.begin), BasicTableUI.this.table.columnAtPoint(this.begin));
                } else {
                    this.updateSelection(e.isControlDown());
                }
                if ((rowLead != rowModel.getLeadSelectionIndex() || colLead != colModel.getLeadSelectionIndex()) && BasicTableUI.this.table.isEditing()) {
                    BasicTableUI.this.table.editingStopped(new ChangeEvent(e));
                }
                BasicTableUI.this.table.requestFocusInWindow();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicTableUI.this.table.isEnabled()) {
                this.begin = null;
                this.curr = null;
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String propName = ev.getPropertyName();
            if (propName.equals("model")) {
                ListSelectionModel rowSel = BasicTableUI.this.table.getSelectionModel();
                rowSel.clearSelection();
                ListSelectionModel colSel = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                colSel.clearSelection();
                TableModel model = BasicTableUI.this.table.getModel();
                if (model.getRowCount() > 0) {
                    rowSel.setAnchorSelectionIndex(0);
                    rowSel.setLeadSelectionIndex(0);
                } else {
                    rowSel.setAnchorSelectionIndex(-1);
                    rowSel.setLeadSelectionIndex(-1);
                }
                if (model.getColumnCount() > 0) {
                    colSel.setAnchorSelectionIndex(0);
                    colSel.setLeadSelectionIndex(0);
                } else {
                    colSel.setAnchorSelectionIndex(-1);
                    colSel.setLeadSelectionIndex(-1);
                }
            }
        }
    }

    private static class TableAction
    extends AbstractAction {
        private TableAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            DefaultListSelectionModel rowModel = (DefaultListSelectionModel)table.getSelectionModel();
            DefaultListSelectionModel colModel = (DefaultListSelectionModel)table.getColumnModel().getSelectionModel();
            int rowLead = rowModel.getLeadSelectionIndex();
            int rowMax = table.getModel().getRowCount() - 1;
            int colLead = colModel.getLeadSelectionIndex();
            int colMax = table.getModel().getColumnCount() - 1;
            String command = (String)this.getValue("__command__");
            if (command.equals("selectPreviousRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(Math.max(rowLead - 1, 0));
            } else if (command.equals("selectLastColumn")) {
                colModel.setSelectionInterval(colMax, colMax);
            } else if (command.equals("startEditing")) {
                if (table.isCellEditable(rowLead, colLead)) {
                    table.editCellAt(rowLead, colLead);
                }
            } else if (command.equals("selectFirstRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(0);
            } else if (command.equals("selectFirstColumn")) {
                colModel.setSelectionInterval(0, 0);
            } else if (command.equals("selectFirstColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(0);
            } else if (command.equals("selectLastRow")) {
                rowModel.setSelectionInterval(rowMax, rowMax);
            } else if (command.equals("selectNextRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(Math.min(rowLead + 1, rowMax));
            } else if (command.equals("selectFirstRow")) {
                rowModel.setSelectionInterval(0, 0);
            } else if (command.equals("selectNextColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(Math.min(colLead + 1, colMax));
            } else if (command.equals("selectLastColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(colMax);
            } else if (command.equals("selectPreviousColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(Math.max(colLead - 1, 0));
            } else if (command.equals("selectNextRow")) {
                rowModel.setSelectionInterval(Math.min(rowLead + 1, rowMax), Math.min(rowLead + 1, rowMax));
            } else if (command.equals("scrollUpExtendSelection")) {
                int target = rowLead == this.getFirstVisibleRowIndex(table) ? Math.max(0, rowLead - (this.getLastVisibleRowIndex(table) - this.getFirstVisibleRowIndex(table) + 1)) : this.getFirstVisibleRowIndex(table);
                rowModel.setLeadSelectionIndex(target);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("selectPreviousRow")) {
                rowModel.setSelectionInterval(Math.max(rowLead - 1, 0), Math.max(rowLead - 1, 0));
            } else if (command.equals("scrollRightChangeSelection")) {
                int target = colLead == this.getLastVisibleColumnIndex(table) ? Math.min(colMax, colLead + (this.getLastVisibleColumnIndex(table) - this.getFirstVisibleColumnIndex(table) + 1)) : this.getLastVisibleColumnIndex(table);
                colModel.setSelectionInterval(target, target);
                rowModel.setSelectionInterval(rowLead, rowLead);
            } else if (command.equals("selectPreviousColumn")) {
                colModel.setSelectionInterval(Math.max(colLead - 1, 0), Math.max(colLead - 1, 0));
            } else if (command.equals("scrollLeftChangeSelection")) {
                int target = colLead == this.getFirstVisibleColumnIndex(table) ? Math.max(0, colLead - (this.getLastVisibleColumnIndex(table) - this.getFirstVisibleColumnIndex(table) + 1)) : this.getFirstVisibleColumnIndex(table);
                colModel.setSelectionInterval(target, target);
                rowModel.setSelectionInterval(rowLead, rowLead);
            } else if (command.equals("clearSelection")) {
                table.clearSelection();
            } else if (command.equals("cancel")) {
                if (table.isEditing()) {
                    table.editingCanceled(new ChangeEvent("cancel"));
                }
            } else if (command.equals("selectNextRowCell") || command.equals("selectPreviousRowCell") || command.equals("selectNextColumnCell") || command.equals("selectPreviousColumnCell")) {
                int colMinSelected;
                boolean multColsSelected;
                if (table.getSelectedRowCount() == 0 && table.getSelectedColumnCount() == 0) {
                    rowModel.setSelectionInterval(0, 0);
                    colModel.setSelectionInterval(0, 0);
                    return;
                }
                if (!table.isCellSelected(rowLead, colLead)) {
                    rowModel.addSelectionInterval(rowModel.getMinSelectionIndex(), rowModel.getMinSelectionIndex());
                    colModel.addSelectionInterval(colModel.getMinSelectionIndex(), colModel.getMinSelectionIndex());
                    return;
                }
                boolean multRowsSelected = table.getSelectedRowCount() > 1 && table.getRowSelectionAllowed();
                boolean bl = multColsSelected = table.getSelectedColumnCount() > 1 && table.getColumnSelectionAllowed();
                if (!multColsSelected && !multRowsSelected) {
                    if (command.indexOf("Column") != -1) {
                        this.advanceSingleSelection(colModel, colMax, rowModel, rowMax, command.equals("selectPreviousColumnCell"));
                    } else {
                        this.advanceSingleSelection(rowModel, rowMax, colModel, colMax, command.equals("selectPreviousRowCell"));
                    }
                    return;
                }
                int rowMaxSelected = table.getRowSelectionAllowed() ? rowModel.getMaxSelectionIndex() : table.getModel().getRowCount() - 1;
                int rowMinSelected = table.getRowSelectionAllowed() ? rowModel.getMinSelectionIndex() : 0;
                int colMaxSelected = table.getColumnSelectionAllowed() ? colModel.getMaxSelectionIndex() : table.getModel().getColumnCount() - 1;
                int n = colMinSelected = table.getColumnSelectionAllowed() ? colModel.getMinSelectionIndex() : 0;
                if (command.indexOf("Column") != -1) {
                    this.advanceMultipleSelection(table, colModel, colMinSelected, colMaxSelected, rowModel, rowMinSelected, rowMaxSelected, command.equals("selectPreviousColumnCell"), true);
                } else {
                    this.advanceMultipleSelection(table, rowModel, rowMinSelected, rowMaxSelected, colModel, colMinSelected, colMaxSelected, command.equals("selectPreviousRowCell"), false);
                }
            } else if (command.equals("selectNextColumn")) {
                colModel.setSelectionInterval(Math.min(colLead + 1, colMax), Math.min(colLead + 1, colMax));
            } else if (command.equals("scrollLeftExtendSelection")) {
                int target = colLead == this.getFirstVisibleColumnIndex(table) ? Math.max(0, colLead - (this.getLastVisibleColumnIndex(table) - this.getFirstVisibleColumnIndex(table) + 1)) : this.getFirstVisibleColumnIndex(table);
                colModel.setLeadSelectionIndex(target);
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("scrollDownChangeSelection")) {
                int target = rowLead == this.getLastVisibleRowIndex(table) ? Math.min(rowMax, rowLead + (this.getLastVisibleRowIndex(table) - this.getFirstVisibleRowIndex(table) + 1)) : this.getLastVisibleRowIndex(table);
                rowModel.setSelectionInterval(target, target);
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("scrollRightExtendSelection")) {
                int target = colLead == this.getLastVisibleColumnIndex(table) ? Math.min(colMax, colLead + (this.getLastVisibleColumnIndex(table) - this.getFirstVisibleColumnIndex(table) + 1)) : this.getLastVisibleColumnIndex(table);
                colModel.setLeadSelectionIndex(target);
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("selectAll")) {
                table.selectAll();
            } else if (command.equals("selectLastRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(rowMax);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("scrollDownExtendSelection")) {
                int target = rowLead == this.getLastVisibleRowIndex(table) ? Math.min(rowMax, rowLead + (this.getLastVisibleRowIndex(table) - this.getFirstVisibleRowIndex(table) + 1)) : this.getLastVisibleRowIndex(table);
                rowModel.setLeadSelectionIndex(target);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("scrollUpChangeSelection")) {
                int target = rowLead == this.getFirstVisibleRowIndex(table) ? Math.max(0, rowLead - (this.getLastVisibleRowIndex(table) - this.getFirstVisibleRowIndex(table) + 1)) : this.getFirstVisibleRowIndex(table);
                rowModel.setSelectionInterval(target, target);
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("selectNextRowChangeLead")) {
                if (rowModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(Math.min(rowLead + 1, rowMax), Math.min(rowLead + 1, rowMax));
                    colModel.setSelectionInterval(colLead, colLead);
                } else {
                    rowModel.moveLeadSelectionIndex(Math.min(rowLead + 1, rowMax));
                }
            } else if (command.equals("selectPreviousRowChangeLead")) {
                if (rowModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(Math.max(rowLead - 1, 0), Math.min(rowLead - 1, 0));
                    colModel.setSelectionInterval(colLead, colLead);
                } else {
                    rowModel.moveLeadSelectionIndex(Math.max(rowLead - 1, 0));
                }
            } else if (command.equals("selectNextColumnChangeLead")) {
                if (colModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(rowLead, rowLead);
                    colModel.setSelectionInterval(Math.min(colLead + 1, colMax), Math.min(colLead + 1, colMax));
                } else {
                    colModel.moveLeadSelectionIndex(Math.min(colLead + 1, colMax));
                }
            } else if (command.equals("selectPreviousColumnChangeLead")) {
                if (colModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(rowLead, rowLead);
                    colModel.setSelectionInterval(Math.max(colLead - 1, 0), Math.max(colLead - 1, 0));
                } else {
                    colModel.moveLeadSelectionIndex(Math.max(colLead - 1, 0));
                }
            } else if (command.equals("addToSelection")) {
                if (!table.isEditing()) {
                    int oldRowAnchor = rowModel.getAnchorSelectionIndex();
                    int oldColAnchor = colModel.getAnchorSelectionIndex();
                    rowModel.addSelectionInterval(rowLead, rowLead);
                    colModel.addSelectionInterval(colLead, colLead);
                    rowModel.setAnchorSelectionIndex(oldRowAnchor);
                    colModel.setAnchorSelectionIndex(oldColAnchor);
                }
            } else if (command.equals("extendTo")) {
                rowModel.setSelectionInterval(rowModel.getAnchorSelectionIndex(), rowLead);
                colModel.setSelectionInterval(colModel.getAnchorSelectionIndex(), colLead);
            } else if (command.equals("toggleAndAnchor")) {
                if (rowModel.isSelectedIndex(rowLead)) {
                    rowModel.removeSelectionInterval(rowLead, rowLead);
                } else {
                    rowModel.addSelectionInterval(rowLead, rowLead);
                }
                if (colModel.isSelectedIndex(colLead)) {
                    colModel.removeSelectionInterval(colLead, colLead);
                } else {
                    colModel.addSelectionInterval(colLead, colLead);
                }
                rowModel.setAnchorSelectionIndex(rowLead);
                colModel.setAnchorSelectionIndex(colLead);
            } else if (command.equals("stopEditing")) {
                table.editingStopped(new ChangeEvent(command));
            }
            if (table.isEditing() && command != "startEditing" && command != "addToSelection") {
                table.editingStopped(new ChangeEvent("update"));
            }
            table.scrollRectToVisible(table.getCellRect(rowModel.getLeadSelectionIndex(), colModel.getLeadSelectionIndex(), false));
        }

        int getFirstVisibleColumnIndex(JTable table) {
            ComponentOrientation or = table.getComponentOrientation();
            Rectangle r = table.getVisibleRect();
            if (!or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            return table.columnAtPoint(r.getLocation());
        }

        int getLastVisibleColumnIndex(JTable table) {
            ComponentOrientation or = table.getComponentOrientation();
            Rectangle r = table.getVisibleRect();
            if (or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            return table.columnAtPoint(r.getLocation());
        }

        int getFirstVisibleRowIndex(JTable table) {
            ComponentOrientation or = table.getComponentOrientation();
            Rectangle r = table.getVisibleRect();
            if (!or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            return table.rowAtPoint(r.getLocation());
        }

        int getLastVisibleRowIndex(JTable table) {
            ComponentOrientation or = table.getComponentOrientation();
            Rectangle r = table.getVisibleRect();
            r.translate(0, (int)r.getHeight() - 1);
            if (or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            if (table.rowAtPoint(r.getLocation()) == -1) {
                if (this.getFirstVisibleRowIndex(table) == -1) {
                    return -1;
                }
                return table.getModel().getRowCount() - 1;
            }
            return table.rowAtPoint(r.getLocation());
        }

        /*
         * Unable to fully structure code
         */
        void advanceMultipleSelection(JTable table, ListSelectionModel firstModel, int firstMin, int firstMax, ListSelectionModel secondModel, int secondMin, int secondMax, boolean reverse, boolean eventIsTab) {
            block12: {
                block14: {
                    block10: {
                        block13: {
                            block11: {
                                firstLead = firstModel.getLeadSelectionIndex();
                                secondLead = secondModel.getLeadSelectionIndex();
                                numFirsts = eventIsTab != false ? table.getModel().getColumnCount() : table.getModel().getRowCount();
                                v0 = numSeconds = eventIsTab != false ? table.getModel().getRowCount() : table.getModel().getColumnCount();
                                if ((firstLead != firstMax || reverse) && (!reverse || firstLead != firstMin)) break block10;
                                firstModel.addSelectionInterval(reverse != false ? firstMax : firstMin, reverse != false ? firstMax : firstMin);
                                if ((secondLead != secondMax || reverse) && (!reverse || secondLead != secondMin)) break block11;
                                secondModel.addSelectionInterval(reverse != false ? secondMax : secondMin, reverse != false ? secondMax : secondMin);
                                break block12;
                            }
                            if (eventIsTab && table.getRowSelectionAllowed() || !eventIsTab && table.getColumnSelectionAllowed()) {
                                secondsSelected = eventIsTab != false ? table.getSelectedRows() : table.getSelectedColumns();
                            } else {
                                secondsSelected = new int[numSeconds];
                                i = 0;
                                while (i < numSeconds) {
                                    secondsSelected[i] = i;
                                    ++i;
                                }
                            }
                            v1 = secondIndex = reverse != false ? secondsSelected.length - 1 : 0;
                            if (reverse) ** GOTO lbl27
                            while (secondsSelected[secondIndex] <= secondLead) {
                                ++secondIndex;
                            }
                            break block13;
lbl-1000:
                            // 1 sources

                            {
                                --secondIndex;
lbl27:
                                // 2 sources

                                ** while (secondsSelected[secondIndex] >= secondLead)
                            }
                        }
                        secondModel.addSelectionInterval(secondsSelected[secondIndex], secondsSelected[secondIndex]);
                        break block12;
                    }
                    if (eventIsTab && table.getColumnSelectionAllowed() || !eventIsTab && table.getRowSelectionAllowed()) {
                        firstsSelected = eventIsTab != false ? table.getSelectedColumns() : table.getSelectedRows();
                    } else {
                        firstsSelected = new int[numFirsts];
                        i = 0;
                        while (i < numFirsts) {
                            firstsSelected[i] = i;
                            ++i;
                        }
                    }
                    v2 = firstIndex = reverse != false ? firstsSelected.length - 1 : 0;
                    if (reverse) ** GOTO lbl48
                    while (firstsSelected[firstIndex] <= firstLead) {
                        ++firstIndex;
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        --firstIndex;
lbl48:
                        // 2 sources

                        ** while (firstsSelected[firstIndex] >= firstLead)
                    }
                }
                firstModel.addSelectionInterval(firstsSelected[firstIndex], firstsSelected[firstIndex]);
                secondModel.addSelectionInterval(secondLead, secondLead);
            }
        }

        void advanceSingleSelection(ListSelectionModel firstModel, int firstMax, ListSelectionModel secondModel, int secondMax, boolean reverse) {
            int firstLead = firstModel.getLeadSelectionIndex();
            int secondLead = secondModel.getLeadSelectionIndex();
            if (reverse && firstLead == 0) {
                if (secondLead == 0) {
                    secondLead += secondMax + 1;
                }
                secondLead -= 2;
            }
            if (reverse && firstLead == 0 || !reverse && firstLead == firstMax) {
                secondModel.setSelectionInterval((secondLead + 1) % (secondMax + 1), (secondLead + 1) % (secondMax + 1));
            } else {
                secondModel.setSelectionInterval(secondLead, secondLead);
            }
            if (reverse) {
                if (firstLead == 0) {
                    firstLead += firstMax + 1;
                }
                firstLead -= 2;
            }
            firstModel.setSelectionInterval((firstLead + 1) % (firstMax + 1), (firstLead + 1) % (firstMax + 1));
        }
    }
}

