/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.TabSet;

public class StyleConstants {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;
    public static final Object Background = CharacterConstants.Background;
    public static final Object BidiLevel = CharacterConstants.BidiLevel;
    public static final Object Bold = CharacterConstants.Bold;
    public static final Object ComponentAttribute = CharacterConstants.ComponentAttribute;
    public static final Object Family = CharacterConstants.Family;
    public static final Object FontFamily = CharacterConstants.Family;
    public static final Object FontSize = CharacterConstants.Size;
    public static final Object Foreground = CharacterConstants.Foreground;
    public static final Object IconAttribute = CharacterConstants.IconAttribute;
    public static final Object Italic = CharacterConstants.Italic;
    public static final Object Size = CharacterConstants.Size;
    public static final Object StrikeThrough = CharacterConstants.StrikeThrough;
    public static final Object Subscript = CharacterConstants.Subscript;
    public static final Object Superscript = CharacterConstants.Superscript;
    public static final Object Underline = CharacterConstants.Underline;
    public static final Object Alignment = ParagraphConstants.Alignment;
    public static final Object FirstLineIndent = ParagraphConstants.FirstLineIndent;
    public static final Object LeftIndent = ParagraphConstants.LeftIndent;
    public static final Object LineSpacing = ParagraphConstants.LineSpacing;
    public static final Object Orientation = ParagraphConstants.Orientation;
    public static final Object RightIndent = ParagraphConstants.RightIndent;
    public static final Object SpaceAbove = ParagraphConstants.SpaceAbove;
    public static final Object SpaceBelow = ParagraphConstants.SpaceBelow;
    public static final Object TabSet = ParagraphConstants.TabSet;
    public static final String ComponentElementName = "component";
    public static final String IconElementName = "icon";
    public static final Object ComposedTextAttribute = new StyleConstants("composed text");
    public static final Object ModelAttribute = new StyleConstants("model");
    public static final Object NameAttribute = new StyleConstants("name");
    public static final Object ResolveAttribute = new StyleConstants("resolver");
    static ArrayList keys;
    String keyname;

    StyleConstants(String k) {
        this.keyname = k;
        if (keys == null) {
            keys = new ArrayList();
        }
        keys.add(this);
    }

    public String toString() {
        return this.keyname;
    }

    public static int getAlignment(AttributeSet a) {
        Integer i = (Integer)a.getAttribute(Alignment);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public static Color getBackground(AttributeSet a) {
        Color c = (Color)a.getAttribute(Background);
        if (c != null) {
            return c;
        }
        return Color.BLACK;
    }

    public static int getBidiLevel(AttributeSet a) {
        Integer i = (Integer)a.getAttribute(BidiLevel);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public static Component getComponent(AttributeSet a) {
        Component c = (Component)a.getAttribute(ComponentAttribute);
        if (c != null) {
            return c;
        }
        return null;
    }

    public static float getFirstLineIndent(AttributeSet a) {
        Float f = (Float)a.getAttribute(FirstLineIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static String getFontFamily(AttributeSet a) {
        String ff = (String)a.getAttribute(FontFamily);
        if (ff != null) {
            return ff;
        }
        return "Monospaced";
    }

    public static int getFontSize(AttributeSet a) {
        Integer i = (Integer)a.getAttribute(FontSize);
        if (i != null) {
            return i;
        }
        return 12;
    }

    public static Color getForeground(AttributeSet a) {
        Color c = (Color)a.getAttribute(Foreground);
        if (c != null) {
            return c;
        }
        return Color.BLACK;
    }

    public static Icon getIcon(AttributeSet a) {
        return (Icon)a.getAttribute(IconAttribute);
    }

    public static float getLeftIndent(AttributeSet a) {
        Float f = (Float)a.getAttribute(LeftIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static float getLineSpacing(AttributeSet a) {
        Float f = (Float)a.getAttribute(LineSpacing);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static float getRightIndent(AttributeSet a) {
        Float f = (Float)a.getAttribute(RightIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static float getSpaceAbove(AttributeSet a) {
        Float f = (Float)a.getAttribute(SpaceAbove);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static float getSpaceBelow(AttributeSet a) {
        Float f = (Float)a.getAttribute(SpaceBelow);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static TabSet getTabSet(AttributeSet a) {
        return (TabSet)a.getAttribute(TabSet);
    }

    public static boolean isBold(AttributeSet a) {
        Boolean b = (Boolean)a.getAttribute(Bold);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static boolean isItalic(AttributeSet a) {
        Boolean b = (Boolean)a.getAttribute(Italic);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static boolean isStrikeThrough(AttributeSet a) {
        Boolean b = (Boolean)a.getAttribute(StrikeThrough);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static boolean isSubscript(AttributeSet a) {
        Boolean b = (Boolean)a.getAttribute(Subscript);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static boolean isSuperscript(AttributeSet a) {
        Boolean b = (Boolean)a.getAttribute(Superscript);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static boolean isUnderline(AttributeSet a) {
        Boolean b = (Boolean)a.getAttribute(Underline);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static void setAlignment(MutableAttributeSet a, int align) {
        a.addAttribute(Alignment, new Integer(align));
    }

    public static void setBackground(MutableAttributeSet a, Color bg) {
        a.addAttribute(Background, bg);
    }

    public static void setBidiLevel(MutableAttributeSet a, int lev) {
        a.addAttribute(BidiLevel, new Integer(lev));
    }

    public static void setBold(MutableAttributeSet a, boolean b) {
        a.addAttribute(Bold, b);
    }

    public static void setComponent(MutableAttributeSet a, Component c) {
        a.addAttribute(ComponentAttribute, c);
    }

    public static void setFirstLineIndent(MutableAttributeSet a, float i) {
        a.addAttribute(FirstLineIndent, new Float(i));
    }

    public static void setFontFamily(MutableAttributeSet a, String fam) {
        a.addAttribute(FontFamily, fam);
    }

    public static void setFontSize(MutableAttributeSet a, int s) {
        a.addAttribute(FontSize, new Integer(s));
    }

    public static void setForeground(MutableAttributeSet a, Color fg) {
        a.addAttribute(Foreground, fg);
    }

    public static void setIcon(MutableAttributeSet a, Icon c) {
        a.addAttribute("$ename", IconElementName);
        a.addAttribute(IconAttribute, c);
    }

    public static void setItalic(MutableAttributeSet a, boolean b) {
        a.addAttribute(Italic, b);
    }

    public static void setLeftIndent(MutableAttributeSet a, float i) {
        a.addAttribute(LeftIndent, new Float(i));
    }

    public static void setLineSpacing(MutableAttributeSet a, float i) {
        a.addAttribute(LineSpacing, new Float(i));
    }

    public static void setRightIndent(MutableAttributeSet a, float i) {
        a.addAttribute(RightIndent, new Float(i));
    }

    public static void setSpaceAbove(MutableAttributeSet a, float i) {
        a.addAttribute(SpaceAbove, new Float(i));
    }

    public static void setSpaceBelow(MutableAttributeSet a, float i) {
        a.addAttribute(SpaceBelow, new Float(i));
    }

    public static void setStrikeThrough(MutableAttributeSet a, boolean b) {
        a.addAttribute(StrikeThrough, b);
    }

    public static void setSubscript(MutableAttributeSet a, boolean b) {
        a.addAttribute(Subscript, b);
    }

    public static void setSuperscript(MutableAttributeSet a, boolean b) {
        a.addAttribute(Superscript, b);
    }

    public static void setTabSet(MutableAttributeSet a, TabSet tabs) {
        a.addAttribute(TabSet, tabs);
    }

    public static void setUnderline(MutableAttributeSet a, boolean b) {
        a.addAttribute(Underline, b);
    }

    public static class CharacterConstants
    extends StyleConstants
    implements AttributeSet.CharacterAttribute {
        public static final Object Background = ColorConstants.Background;
        public static final Object BidiLevel = new CharacterConstants("bidiLevel");
        public static final Object Bold = FontConstants.Bold;
        public static final Object ComponentAttribute = new CharacterConstants("component");
        public static final Object Family = FontConstants.Family;
        public static final Object Size = FontConstants.Size;
        public static final Object Foreground = ColorConstants.Foreground;
        public static final Object IconAttribute = new CharacterConstants("icon");
        public static final Object Italic = FontConstants.Italic;
        public static final Object StrikeThrough = new CharacterConstants("strikethrough");
        public static final Object Subscript = new CharacterConstants("subscript");
        public static final Object Superscript = new CharacterConstants("superscript");
        public static final Object Underline = new CharacterConstants("underline");

        private CharacterConstants(String k) {
            super(k);
        }
    }

    public static class ColorConstants
    extends StyleConstants
    implements AttributeSet.ColorAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Foreground = new ColorConstants("foreground");
        public static final Object Background = new ColorConstants("background");

        private ColorConstants(String k) {
            super(k);
        }
    }

    public static class FontConstants
    extends StyleConstants
    implements AttributeSet.FontAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Bold = new FontConstants("bold");
        public static final Object Family = new FontConstants("family");
        public static final Object Italic = new FontConstants("italic");
        public static final Object Size = new FontConstants("size");

        private FontConstants(String k) {
            super(k);
        }
    }

    public static class ParagraphConstants
    extends StyleConstants
    implements AttributeSet.ParagraphAttribute {
        public static final Object Alignment = new ParagraphConstants("Alignment");
        public static final Object FirstLineIndent = new ParagraphConstants("FirstLineIndent");
        public static final Object LeftIndent = new ParagraphConstants("LeftIndent");
        public static final Object LineSpacing = new ParagraphConstants("LineSpacing");
        public static final Object Orientation = new ParagraphConstants("Orientation");
        public static final Object RightIndent = new ParagraphConstants("RightIndent");
        public static final Object SpaceAbove = new ParagraphConstants("SpaceAbove");
        public static final Object SpaceBelow = new ParagraphConstants("SpaceBelow");
        public static final Object TabSet = new ParagraphConstants("TabSet");

        private ParagraphConstants(String k) {
            super(k);
        }
    }
}

