/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.text.BreakIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;

public class Utilities {
    public static final int drawTabbedText(Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        char[] buffer = s.array;
        FontMetrics metrics = g.getFontMetrics();
        metrics.getAscent();
        int pixelX = x;
        int pos = s.offset;
        int len = 0;
        int end = s.offset + s.count;
        int offset = s.offset;
        while (offset < end) {
            char c = buffer[offset];
            switch (c) {
                case '\t': {
                    if (len > 0) {
                        g.drawChars(buffer, pos, len, pixelX, y);
                        pixelX += metrics.charsWidth(buffer, pos, len);
                        len = 0;
                    }
                    pos = offset + 1;
                    pixelX = e != null ? (int)e.nextTabStop(pixelX, startOffset + offset - s.offset) : (pixelX += metrics.charWidth(' '));
                    x = pixelX;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (len > 0) {
                        g.drawChars(buffer, pos, len, pixelX, y);
                        pixelX += metrics.charsWidth(buffer, pos, len);
                        len = 0;
                    }
                    x = pixelX;
                    break;
                }
                default: {
                    ++len;
                }
            }
            ++offset;
        }
        if (len > 0) {
            g.drawChars(buffer, pos, len, pixelX, y);
            pixelX += metrics.charsWidth(buffer, pos, len);
        }
        return pixelX;
    }

    public static final int getTabbedTextWidth(Segment s, FontMetrics metrics, int x, TabExpander e, int startOffset) {
        char[] buffer = s.array;
        int pixelX = x;
        int end = s.offset + s.count;
        int count = 0;
        int offset = s.offset;
        while (offset < end) {
            switch (buffer[offset]) {
                case '\t': {
                    if (e != null) {
                        pixelX = (int)e.nextTabStop(pixelX, startOffset + offset - s.offset);
                        break;
                    }
                    pixelX += metrics.charWidth(' ');
                    break;
                }
                case '\n': {
                    pixelX += metrics.charsWidth(buffer, offset - count, count);
                    count = 0;
                    break;
                }
                default: {
                    ++count;
                }
            }
            ++offset;
        }
        return (pixelX += metrics.charsWidth(buffer, end - count, count)) - x;
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics fm, int x0, int x, TabExpander te, int p0, boolean round) {
        int currentX;
        int found = s.count;
        int nextX = currentX = x0;
        int end = s.offset + s.count;
        int pos = s.offset;
        while (pos < end && found == s.count) {
            char nextChar = s.array[pos];
            nextX = nextChar != '\t' ? (nextX += fm.charWidth(nextChar)) : (te == null ? (nextX += fm.charWidth(' ')) : (nextX += (int)te.nextTabStop(nextX, p0 + pos - s.offset)));
            if (x >= currentX && x < nextX) {
                found = !round || x - currentX < nextX - x ? pos - s.offset : pos + 1 - s.offset;
            }
            currentX = nextX;
            ++pos;
        }
        return found;
    }

    public static final int getTabbedTextOffset(Segment s, FontMetrics fm, int x0, int x, TabExpander te, int p0) {
        return Utilities.getTabbedTextOffset(s, fm, x0, x, te, p0, true);
    }

    public static final int getNextWord(JTextComponent c, int offs) throws BadLocationException {
        if (offs < 0 || offs > c.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        String text = c.getText();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        int last = wb.following(offs);
        int current = wb.next();
        while (current != -1) {
            int i = last;
            while (i < current) {
                int cp = text.codePointAt(i);
                if (Character.isLetter(cp) || !Character.isWhitespace(cp)) {
                    return last;
                }
                ++i;
            }
            last = current;
            current = wb.next();
        }
        throw new BadLocationException("no more words", offs);
    }

    public static final int getPreviousWord(JTextComponent c, int offs) throws BadLocationException {
        String text = c.getText();
        if (offs <= 0 || offs > text.length()) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        int last = wb.preceding(offs);
        int current = wb.previous();
        while (current != -1) {
            int i = last;
            while (i < offs) {
                int cp = text.codePointAt(i);
                if (Character.isLetter(cp) || !Character.isWhitespace(cp)) {
                    return last;
                }
                ++i;
            }
            last = current;
            current = wb.previous();
        }
        return 0;
    }

    public static final int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        String text = c.getText();
        if (offs < 0 || offs > text.length()) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        if (wb.isBoundary(offs)) {
            return offs;
        }
        return wb.preceding(offs);
    }

    public static final int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        if (offs < 0 || offs >= c.getText().length()) {
            throw new BadLocationException("invalid offset specified", offs);
        }
        String text = c.getText();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        return wb.following(offs);
    }

    public static final int getRowEnd(JTextComponent c, int offs) throws BadLocationException {
        String text = c.getText();
        if (text == null) {
            return -1;
        }
        int high = offs + (text.length() - 1 - offs) / 2;
        int low = offs;
        int oldHigh = text.length() + 1;
        while (true) {
            if (c.modelToView((int)high).y != c.modelToView((int)offs).y) {
                oldHigh = high;
                if (oldHigh != (high = low + (high + 1 - low) / 2)) continue;
                return high - 1;
            }
            low = high;
            if (low == (high += (oldHigh - high) / 2)) break;
        }
        return low;
    }

    public static final int getRowStart(JTextComponent c, int offs) throws BadLocationException {
        String text = c.getText();
        if (text == null) {
            return -1;
        }
        int high = offs;
        int low = 0;
        int oldLow = 0;
        while (true) {
            if (c.modelToView((int)low).y != c.modelToView((int)offs).y) {
                oldLow = low;
                if (oldLow != (low = high - (high + 1 - low) / 2)) continue;
                return low + 1;
            }
            if ((low -= (low - oldLow) / 2) == (high = low)) break;
        }
        return low;
    }

    public static final int getBreakLocation(Segment s, FontMetrics metrics, int x0, int x, TabExpander e, int startOffset) {
        int mark;
        int breakLoc = mark = Utilities.getTabbedTextOffset(s, metrics, x0, x, e, startOffset, false);
        if (mark < s.count - 1) {
            int i = s.offset + mark;
            while (i >= s.offset) {
                char ch = s.array[i];
                if (ch < '\u0100') {
                    if (Character.isWhitespace(ch)) {
                        breakLoc = i - s.offset + 1;
                        break;
                    }
                } else {
                    BreakIterator bi = BreakIterator.getLineInstance();
                    bi.setText(s);
                    int pos = bi.preceding(i + 1);
                    if (pos <= s.offset) break;
                    breakLoc -= s.offset;
                    break;
                }
                --i;
            }
        }
        return breakLoc;
    }

    public static final Element getParagraphElement(JTextComponent c, int offset) {
        Document doc = c.getDocument();
        Element par = null;
        if (doc instanceof StyledDocument) {
            StyledDocument styledDoc = (StyledDocument)doc;
            par = styledDoc.getParagraphElement(offset);
        } else {
            Element root = c.getDocument().getDefaultRootElement();
            int parIndex = root.getElementIndex(offset);
            par = root.getElement(parIndex);
        }
        return par;
    }

    public static final int getPositionAbove(JTextComponent c, int offset, int x) throws BadLocationException {
        int offs = Utilities.getRowStart(c, offset);
        if (offs == -1) {
            return -1;
        }
        Point pt = c.modelToView(offs - 1).getLocation();
        pt.x = x;
        offs = c.viewToModel(pt);
        int offsX = c.modelToView((int)offs).getLocation().x;
        int offsXNext = c.modelToView((int)(offs + 1)).getLocation().x;
        if (Math.abs(offsX - x) <= Math.abs(offsXNext - x)) {
            return offs;
        }
        return offs + 1;
    }

    public static final int getPositionBelow(JTextComponent c, int offset, int x) throws BadLocationException {
        int offs = Utilities.getRowEnd(c, offset);
        if (offs == -1) {
            return -1;
        }
        Point pt = null;
        try {
            pt = c.modelToView(offs + 1).getLocation();
        }
        catch (BadLocationException badLocationException) {
            return offset;
        }
        pt.x = x;
        offs = c.viewToModel(pt);
        if (offs == c.getDocument().getLength()) {
            return offs;
        }
        int offsX = c.modelToView((int)offs).getLocation().x;
        int offsXNext = c.modelToView((int)(offs + 1)).getLocation().x;
        if (Math.abs(offsX - x) <= Math.abs(offsXNext - x)) {
            return offs;
        }
        return offs + 1;
    }

    static int getNextVisualPositionFrom(JTextComponent t, int offset, int direction) {
        NavigationFilter nf = t.getNavigationFilter();
        try {
            return nf != null ? nf.getNextVisualPositionFrom(t, offset, Position.Bias.Forward, direction, new Position.Bias[1]) : t.getUI().getNextVisualPositionFrom(t, offset, Position.Bias.Forward, direction, new Position.Bias[1]);
        }
        catch (BadLocationException badLocationException) {
            return offset;
        }
    }
}

