/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFParseException;
import javax.swing.text.rtf.RTFScanner;
import javax.swing.text.rtf.TextToken;
import javax.swing.text.rtf.Token;

class RTFParser {
    private RTFScanner scanner;
    private Document doc;
    private int pos;

    private RTFParser(Document doc, int pos) {
        this.doc = doc;
        this.pos = pos;
    }

    public RTFParser(InputStream stream, Document doc, int pos) {
        this(doc, pos);
        this.scanner = new RTFScanner(stream);
    }

    public RTFParser(Reader reader, Document doc, int pos) {
        this(doc, pos);
        this.scanner = new RTFScanner(reader);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void parse() throws IOException, BadLocationException {
        this.parseFile();
    }

    private void parseFile() throws IOException, BadLocationException {
        Token t1 = this.scanner.readToken();
        if (t1.type != 1) {
            throw new RTFParseException("expected left curly braces");
        }
        this.parseHeader();
        this.parseDocument();
        Token t2 = this.scanner.peekToken();
        if (t2.type == 2) {
            this.scanner.readToken();
        } else {
            System.err.println("RTF warning: expected right curly braces");
        }
    }

    private void parseHeader() {
    }

    private void parseDocument() throws IOException, BadLocationException {
        boolean eof = false;
        do {
            Token token = this.scanner.readToken();
            switch (token.type) {
                case 4: {
                    TextToken textToken = (TextToken)token;
                    this.doc.insertString(this.pos, textToken.text, null);
                    this.pos += textToken.text.length();
                    break;
                }
                case -1: {
                    eof = true;
                    break;
                }
            }
        } while (!eof);
    }
}

