/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import java.text.CharacterIterator;

public final class ArrayCharacterIterator
implements CharacterIterator {
    private char[] data;
    private int beginIndex;
    private int endIndex;
    private int currentIndex;

    public ArrayCharacterIterator(char[] data, int beginIndex) {
        this(data, beginIndex, data.length, beginIndex);
    }

    public ArrayCharacterIterator(char[] data, int beginIndex, int endIndex) {
        this(data, beginIndex, endIndex, beginIndex);
    }

    public ArrayCharacterIterator(char[] data, int beginIndex, int endIndex, int currentIndex) {
        this.data = data;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.currentIndex = currentIndex;
    }

    public Object clone() {
        return new ArrayCharacterIterator(this.data, this.beginIndex, this.endIndex, this.currentIndex);
    }

    public char current() {
        return this.currentIndex >= this.beginIndex && this.currentIndex < this.endIndex ? this.data[this.currentIndex] : (char)'\uffff';
    }

    public char first() {
        this.currentIndex = this.beginIndex;
        return this.data[this.currentIndex];
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public char last() {
        this.currentIndex = this.endIndex > this.beginIndex ? this.endIndex - 1 : this.endIndex;
        return this.data[this.currentIndex];
    }

    public char next() {
        return ++this.currentIndex < this.endIndex ? this.data[this.currentIndex] : (char)'\uffff';
    }

    public char previous() {
        return --this.currentIndex >= this.beginIndex ? this.data[this.currentIndex] : (char)'\uffff';
    }

    public char setIndex(int position) {
        this.currentIndex = position;
        return this.current();
    }
}

